/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.ui;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.examples.flow.FlowEditorPaletteFactory;
import org.eclipse.gef.examples.flow.actions.FlowContextMenuProvider;
import org.eclipse.gef.examples.flow.model.ActivityDiagram;
import org.eclipse.gef.examples.flow.parts.ActivityPartFactory;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class FlowEditor
extends GraphicalEditorWithPalette {
    ActivityDiagram diagram;
    private PaletteRoot root;
    private KeyHandler sharedKeyHandler;

    public FlowEditor() {
        DefaultEditDomain defaultEditDomain = new DefaultEditDomain((IEditorPart)this);
        this.setEditDomain(defaultEditDomain);
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        DirectEditAction action = new DirectEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    protected void createOutputStream(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(this.diagram);
        out.close();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().setRootEditPart((RootEditPart)new ScalableRootEditPart());
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new ActivityPartFactory());
        this.getGraphicalViewer().setKeyHandler(new GraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(this.getCommonKeyHandler()));
        FlowContextMenuProvider provider = new FlowContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.gef.examples.flow.editor.contextmenu", (MenuManager)provider, (ISelectionProvider)this.getGraphicalViewer());
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.diagram);
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
    }

    protected void initializePaletteViewer() {
        super.initializePaletteViewer();
        this.getPaletteViewer().addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)this.getPaletteViewer()));
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = FlowEditorPaletteFactory.createPalette();
        }
        return this.root;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.diagram = new ActivityDiagram();
    }
}

