/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.layouts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class GridLayoutExample
extends AbstractExample {
    Figure container;
    Composite composite;
    GridLayout gridLayout;
    Text widthHint;
    Text heightHint;
    Text horizIndent;
    Text vertSpan;
    Text horizSpan;
    Combo vertAlign;
    Combo horizAlign;
    Button grabVSpace;
    Button grabHSpace;
    org.eclipse.swt.layout.GridLayout _layout;
    org.eclipse.swt.layout.GridData _data;
    Shape selectedShape = null;
    Shape prevSelectedShape = null;
    int shapeCount = 0;
    int colorCount = 0;
    Color[] colors = new Color[]{ColorConstants.blue, ColorConstants.red, ColorConstants.yellow, ColorConstants.gray, ColorConstants.green, ColorConstants.lightBlue, ColorConstants.cyan, ColorConstants.darkGreen, ColorConstants.orange};

    public static void main(String[] args) {
        new GridLayoutExample().run();
    }

    protected IFigure getContents() {
        this.container = new Figure();
        this.container.setBorder((Border)new LineBorder());
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = false;
        this.container.setLayoutManager((LayoutManager)this.gridLayout);
        this.container.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent event) {
                if (GridLayoutExample.this.selectedShape != null) {
                    GridLayoutExample.this.prevSelectedShape.setLineWidth(1);
                }
                GridLayoutExample.this.prevSelectedShape = null;
                GridLayoutExample.this.selectedShape = null;
                GridLayoutExample.this.setEnableGridDataGroup(false);
            }
        });
        Shape shape = this.createShape();
        this.container.add((IFigure)shape);
        this.container.add((IFigure)this.createShape());
        return this.container;
    }

    protected Shape createShape() {
        Object shape = null;
        shape = this.shapeCount == 0 ? new Ellipse() : (this.shapeCount == 1 ? new RectangleFigure() : (this.shapeCount == 2 ? new RoundedRectangle() : (this.shapeCount == 3 ? new RectangleFigure() : (this.shapeCount == 4 ? new Ellipse() : (this.shapeCount == 5 ? new Triangle() : (this.shapeCount == 6 ? new RoundedRectangle() : (this.shapeCount == 7 ? new Triangle() : new RoundedRectangle())))))));
        shape.setBackgroundColor(this.colors[this.colorCount]);
        shape.setSize(70, 70);
        shape.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent event) {
                GridLayoutExample.this.selectedShape = (Shape)event.getSource();
                GridLayoutExample.this.setEnableGridDataGroup(true);
                GridLayoutExample.this.selectedShape.setLineWidth(4);
                if (GridLayoutExample.this.prevSelectedShape != null && GridLayoutExample.this.prevSelectedShape != GridLayoutExample.this.selectedShape) {
                    GridLayoutExample.this.prevSelectedShape.setLineWidth(1);
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                GridLayoutExample.this.populateGridDataGroup(d);
                GridLayoutExample.this.prevSelectedShape = GridLayoutExample.this.selectedShape;
            }
        });
        if (this.shapeCount == 8) {
            this.colorCount = 0;
            this.shapeCount = 0;
        } else {
            ++this.shapeCount;
            ++this.colorCount;
        }
        return shape;
    }

    protected Integer getEventValue(Event e, String id) {
        int val = 1;
        try {
            if (e.widget instanceof Text) {
                val = Integer.parseInt(((Text)e.widget).getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error: Invalid Number entered for " + id);
        }
        return new Integer(val);
    }

    protected Integer getEventValue(SelectionEvent e, String id) {
        int val = 5;
        try {
            if (e.widget instanceof Combo) {
                val = Integer.parseInt(((Combo)e.widget).getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error: Invalid Number entered for " + id);
        }
        return new Integer(val);
    }

    protected void updateView() {
        this.contents.revalidate();
        this.shell.pack();
    }

    protected void createColumnGroup() {
        Group columnsGroup = new Group(this.composite, 0);
        columnsGroup.setText("Columns");
        this._layout = new org.eclipse.swt.layout.GridLayout();
        this._layout.numColumns = 2;
        columnsGroup.setLayout((Layout)this._layout);
        this._data = new org.eclipse.swt.layout.GridData(16);
        columnsGroup.setLayoutData((Object)this._data);
        Text numColumns = new Text((Composite)columnsGroup, 2048);
        numColumns.setText("2");
        numColumns.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                GridLayoutExample.this.gridLayout.numColumns = GridLayoutExample.this.getEventValue(e, "numColumns");
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 15;
        numColumns.setLayoutData((Object)this._data);
        new Label((Composite)columnsGroup, 0).setText("numColumns");
        Button makeColumnsEqualWidth = new Button((Composite)columnsGroup, 32);
        makeColumnsEqualWidth.setText("makeColumnsEqualWidth");
        makeColumnsEqualWidth.setSelection(false);
        makeColumnsEqualWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.gridLayout.makeColumnsEqualWidth = !GridLayoutExample.this.gridLayout.makeColumnsEqualWidth;
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.horizontalSpan = 2;
        this._data.horizontalIndent = 14;
        makeColumnsEqualWidth.setLayoutData((Object)this._data);
    }

    protected void createMarginGroup() {
        Group marginGroup = new Group(this.composite, 0);
        marginGroup.setLayout((Layout)new FillLayout(512));
        marginGroup.setText("Margins and Spacing");
        String[] marginValues = new String[]{"0", "3", "5", "10"};
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.verticalSpan = 2;
        marginGroup.setLayoutData((Object)this._data);
        this._layout = new org.eclipse.swt.layout.GridLayout();
        this._layout.numColumns = 2;
        marginGroup.setLayout((Layout)this._layout);
        new Label((Composite)marginGroup, 0).setText("marginHeight");
        Combo marginHeight = new Combo((Composite)marginGroup, 0);
        marginHeight.setItems(marginValues);
        marginHeight.select(2);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 60;
        marginHeight.setLayoutData((Object)this._data);
        marginHeight.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                GridLayoutExample.this.gridLayout.marginHeight = GridLayoutExample.this.getEventValue(e, "marginHeight");
                GridLayoutExample.this.updateView();
            }
        });
        marginHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.gridLayout.marginHeight = GridLayoutExample.this.getEventValue(e, "marginHeight");
                GridLayoutExample.this.updateView();
            }
        });
        new Label((Composite)marginGroup, 0).setText("marginWidth");
        Combo marginWidth = new Combo((Composite)marginGroup, 0);
        marginWidth.setItems(marginValues);
        marginWidth.select(2);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 60;
        marginWidth.setLayoutData((Object)this._data);
        marginWidth.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                GridLayoutExample.this.gridLayout.marginWidth = GridLayoutExample.this.getEventValue(e, "marginWidth");
                GridLayoutExample.this.updateView();
            }
        });
        marginWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.gridLayout.marginWidth = GridLayoutExample.this.getEventValue(e, "marginWidth");
                GridLayoutExample.this.updateView();
            }
        });
        new Label((Composite)marginGroup, 0).setText("horizontalSpacing");
        Combo horizontalSpacing = new Combo((Composite)marginGroup, 0);
        horizontalSpacing.setItems(marginValues);
        horizontalSpacing.select(2);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 60;
        horizontalSpacing.setLayoutData((Object)this._data);
        horizontalSpacing.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                GridLayoutExample.this.gridLayout.horizontalSpacing = GridLayoutExample.this.getEventValue(e, "horizontalSpacing");
                GridLayoutExample.this.updateView();
            }
        });
        horizontalSpacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.gridLayout.horizontalSpacing = GridLayoutExample.this.getEventValue(e, "horizontalSpacing");
                GridLayoutExample.this.updateView();
            }
        });
        new Label((Composite)marginGroup, 0).setText("verticalSpacing");
        Combo verticalSpacing = new Combo((Composite)marginGroup, 0);
        verticalSpacing.setItems(marginValues);
        verticalSpacing.select(2);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 60;
        verticalSpacing.setLayoutData((Object)this._data);
        verticalSpacing.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                GridLayoutExample.this.gridLayout.verticalSpacing = GridLayoutExample.this.getEventValue(e, "verticalSpacing");
                GridLayoutExample.this.updateView();
            }
        });
        verticalSpacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.gridLayout.verticalSpacing = GridLayoutExample.this.getEventValue(e, "verticalSpacing");
                GridLayoutExample.this.updateView();
            }
        });
    }

    protected void createChildGroup() {
        Group childGroup = new Group(this.composite, 0);
        childGroup.setText("Children");
        org.eclipse.swt.layout.GridLayout layout = new org.eclipse.swt.layout.GridLayout();
        layout.numColumns = 3;
        childGroup.setLayout((Layout)layout);
        org.eclipse.swt.layout.GridData data = new org.eclipse.swt.layout.GridData(768);
        data.horizontalSpan = 2;
        childGroup.setLayoutData((Object)data);
        Button add = new Button((Composite)childGroup, 8);
        add.setText("Add");
        add.setLayoutData((Object)new org.eclipse.swt.layout.GridData(768));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.container.add((IFigure)GridLayoutExample.this.createShape());
                GridLayoutExample.this.updateView();
            }
        });
        Button clear = new Button((Composite)childGroup, 8);
        clear.setText("Clear All");
        clear.setLayoutData((Object)new org.eclipse.swt.layout.GridData(768));
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridLayoutExample.this.container.removeAll();
                GridLayoutExample.this.setEnableGridDataGroup(false);
                GridLayoutExample.this.updateView();
            }
        });
    }

    protected void createGridDataGroup() {
        String[] alignValues = new String[]{"BEGINNING", "CENTER", "END", "FILL"};
        Group gridDataGroup = new Group(this.composite, 0);
        gridDataGroup.setText("Selected Figure's GridData");
        this._layout = new org.eclipse.swt.layout.GridLayout();
        this._layout.numColumns = 2;
        gridDataGroup.setLayout((Layout)this._layout);
        this._data = new org.eclipse.swt.layout.GridData(16);
        gridDataGroup.setLayoutData((Object)this._data);
        this.widthHint = new Text((Composite)gridDataGroup, 2048);
        this.widthHint.setText("-1");
        this.widthHint.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                d.widthHint = GridLayoutExample.this.getEventValue(e, "widthHint");
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 35;
        this.widthHint.setLayoutData((Object)this._data);
        new Label((Composite)gridDataGroup, 0).setText("widthHint");
        this.heightHint = new Text((Composite)gridDataGroup, 2048);
        this.heightHint.setText("-1");
        this.heightHint.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                d.heightHint = GridLayoutExample.this.getEventValue(e, "heightHint");
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 35;
        this.heightHint.setLayoutData((Object)this._data);
        new Label((Composite)gridDataGroup, 0).setText("heightHint");
        this.horizAlign = new Combo((Composite)gridDataGroup, 8);
        this.horizAlign.setItems(alignValues);
        this.horizAlign.select(0);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 60;
        this.horizAlign.setLayoutData((Object)this._data);
        this.horizAlign.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                String align = ((Combo)e.widget).getText();
                d.horizontalAlignment = GridLayoutExample.this.findAlignment(align);
                GridLayoutExample.this.updateView();
            }
        });
        new Label((Composite)gridDataGroup, 0).setText("horizontalAlignment");
        this.vertAlign = new Combo((Composite)gridDataGroup, 8);
        this.vertAlign.setItems(alignValues);
        this.vertAlign.select(0);
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 60;
        this.vertAlign.setLayoutData((Object)this._data);
        this.vertAlign.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                String align = ((Combo)e.widget).getText();
                d.verticalAlignment = GridLayoutExample.this.findAlignment(align);
                GridLayoutExample.this.updateView();
            }
        });
        new Label((Composite)gridDataGroup, 0).setText("verticalAlignment");
        this.horizIndent = new Text((Composite)gridDataGroup, 2048);
        this.horizIndent.setText("0");
        this.horizIndent.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                d.horizontalIndent = GridLayoutExample.this.getEventValue(e, "horizontalIndent");
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 35;
        this.horizIndent.setLayoutData((Object)this._data);
        new Label((Composite)gridDataGroup, 0).setText("horizontalIndent");
        this.horizSpan = new Text((Composite)gridDataGroup, 2048);
        this.horizSpan.setText("1");
        this.horizSpan.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                d.horizontalSpan = GridLayoutExample.this.getEventValue(e, "horizontalSpan");
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 35;
        this.horizSpan.setLayoutData((Object)this._data);
        new Label((Composite)gridDataGroup, 0).setText("horizontalSpan");
        this.vertSpan = new Text((Composite)gridDataGroup, 2048);
        this.vertSpan.setText("1");
        this.vertSpan.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                d.verticalSpan = GridLayoutExample.this.getEventValue(e, "verticalSpan");
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.widthHint = 35;
        this.vertSpan.setLayoutData((Object)this._data);
        new Label((Composite)gridDataGroup, 0).setText("verticalSpan");
        this.grabHSpace = new Button((Composite)gridDataGroup, 32);
        this.grabHSpace.setText("grabExcessHorizontalSpace");
        this.grabHSpace.setSelection(false);
        this.grabHSpace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                d.grabExcessHorizontalSpace = !d.grabExcessHorizontalSpace;
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.horizontalSpan = 2;
        this._data.horizontalIndent = 14;
        this.grabHSpace.setLayoutData((Object)this._data);
        this.grabVSpace = new Button((Composite)gridDataGroup, 32);
        this.grabVSpace.setText("grabExcessVerticalSpace");
        this.grabVSpace.setSelection(false);
        this.grabVSpace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GridLayoutExample.this.selectedShape == null) {
                    return;
                }
                GridData d = (GridData)GridLayoutExample.this.gridLayout.getConstraint((IFigure)GridLayoutExample.this.selectedShape);
                d.grabExcessVerticalSpace = !d.grabExcessVerticalSpace;
                GridLayoutExample.this.updateView();
            }
        });
        this._data = new org.eclipse.swt.layout.GridData();
        this._data.horizontalSpan = 2;
        this._data.horizontalIndent = 14;
        this.grabVSpace.setLayoutData((Object)this._data);
        this.setEnableGridDataGroup(false);
    }

    protected void setEnableGridDataGroup(boolean enable) {
        this.widthHint.setEnabled(enable);
        this.heightHint.setEnabled(enable);
        this.horizIndent.setEnabled(enable);
        this.vertSpan.setEnabled(enable);
        this.horizSpan.setEnabled(enable);
        this.vertAlign.setEnabled(enable);
        this.horizAlign.setEnabled(enable);
        this.grabVSpace.setEnabled(enable);
        this.grabHSpace.setEnabled(enable);
    }

    protected void populateGridDataGroup(GridData d) {
        this.widthHint.setText(Integer.toString(d.widthHint));
        this.heightHint.setText(Integer.toString(d.heightHint));
        this.horizIndent.setText(Integer.toString(d.horizontalIndent));
        this.vertSpan.setText(Integer.toString(d.verticalSpan));
        this.horizSpan.setText(Integer.toString(d.horizontalSpan));
        this.vertAlign.select(this.findAlignment(d.verticalAlignment));
        this.horizAlign.select(this.findAlignment(d.horizontalAlignment));
        this.grabVSpace.setSelection(d.grabExcessVerticalSpace);
        this.grabHSpace.setSelection(d.grabExcessHorizontalSpace);
    }

    protected int findAlignment(int align) {
        switch (align) {
            case 1: {
                return 0;
            }
            case 0x1000000: {
                return 1;
            }
            case 0x1000008: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return -1;
    }

    protected int findAlignment(String align) {
        if (align.equals("BEGINNING")) {
            return 1;
        }
        if (align.equals("CENTER")) {
            return 0x1000000;
        }
        if (align.equals("END")) {
            return 0x1000008;
        }
        if (align.equals("FILL")) {
            return 4;
        }
        return -1;
    }

    protected void hookShell() {
        this.composite = new Composite((Composite)this.shell, 0);
        this._data = new org.eclipse.swt.layout.GridData(1040);
        this._data.widthHint = 300;
        this.composite.setLayoutData((Object)this._data);
        this.composite.setLayout((Layout)new org.eclipse.swt.layout.GridLayout());
        this.createColumnGroup();
        this.createMarginGroup();
        this.createChildGroup();
        this.createGridDataGroup();
    }
}

