/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.layouts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

public class FlowLayoutExample
extends AbstractExample {
    FlowLayout layout;

    public static void main(String[] args) {
        new FlowLayoutExample().run();
    }

    protected IFigure getContents() {
        Figure container = new Figure();
        container.setBorder((Border)new LineBorder());
        this.layout = new FlowLayout();
        container.setLayoutManager((LayoutManager)this.layout);
        Ellipse shape = new Ellipse();
        shape.setBackgroundColor(ColorConstants.blue);
        shape.setSize(60, 40);
        container.add((IFigure)shape);
        shape = new RectangleFigure();
        shape.setBackgroundColor(ColorConstants.red);
        shape.setSize(30, 70);
        container.add((IFigure)shape);
        shape = new RoundedRectangle();
        shape.setBackgroundColor(ColorConstants.yellow);
        shape.setSize(90, 30);
        container.add((IFigure)shape);
        shape = new RectangleFigure();
        shape.setBackgroundColor(ColorConstants.gray);
        shape.setSize(50, 80);
        container.add((IFigure)shape);
        shape = new Ellipse();
        shape.setBackgroundColor(ColorConstants.green);
        shape.setSize(50, 50);
        container.add((IFigure)shape);
        shape = new Triangle();
        shape.setBackgroundColor(ColorConstants.black);
        shape.setSize(50, 50);
        container.add((IFigure)shape);
        shape = new RoundedRectangle();
        shape.setBackgroundColor(ColorConstants.cyan);
        shape.setSize(50, 50);
        container.add((IFigure)shape);
        shape = new RectangleFigure();
        shape.setBackgroundColor(ColorConstants.darkGreen);
        shape.setSize(50, 50);
        container.add((IFigure)shape);
        shape = new Triangle();
        shape.setBackgroundColor(ColorConstants.orange);
        shape.setSize(50, 50);
        container.add((IFigure)shape);
        shape = new Ellipse();
        shape.setBackgroundColor(ColorConstants.red);
        shape.setSize(50, 50);
        container.add((IFigure)shape);
        shape = new RoundedRectangle();
        shape.setBackgroundColor(ColorConstants.yellow);
        shape.setSize(50, 50);
        container.add((IFigure)shape);
        return container;
    }

    protected void hookShell() {
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(1040));
        composite.setLayout((Layout)new GridLayout());
        Button horizontal = new Button(composite, 32);
        horizontal.setText("Horizontal");
        horizontal.setSelection(true);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setHorizontal(!FlowLayoutExample.this.layout.isHorizontal());
                FlowLayoutExample.this.contents.revalidate();
                FlowLayoutExample.this.shell.layout(true);
            }
        });
        Group major = new Group(composite, 0);
        major.setLayout((Layout)new FillLayout(512));
        major.setText("Major Axis");
        Button left = new Button((Composite)major, 16);
        left.setText("Top/Left");
        left.setSelection(true);
        left.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMajorAlignment(1);
                FlowLayoutExample.this.contents.revalidate();
            }
        });
        Button center = new Button((Composite)major, 16);
        center.setText("Middle/Center");
        center.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMajorAlignment(0);
                FlowLayoutExample.this.contents.revalidate();
            }
        });
        Button right = new Button((Composite)major, 16);
        right.setText("Buttom/Right");
        right.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMajorAlignment(2);
                FlowLayoutExample.this.contents.revalidate();
            }
        });
        final Scale spacing = new Scale((Composite)major, 0);
        spacing.setMinimum(0);
        spacing.setMaximum(20);
        spacing.setSelection(5);
        spacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMajorSpacing(spacing.getSelection());
                FlowLayoutExample.this.contents.revalidate();
            }
        });
        Label spacingLabel = new Label((Composite)major, 0x1000000);
        spacingLabel.setText("Spacing");
        Group minor = new Group(composite, 0);
        minor.setLayout((Layout)new FillLayout(512));
        minor.setText("minor axis");
        left = new Button((Composite)minor, 16);
        left.setText("Top/Left");
        left.setSelection(true);
        left.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMinorAlignment(1);
                FlowLayoutExample.this.contents.revalidate();
            }
        });
        center = new Button((Composite)minor, 16);
        center.setText("Middle/Center");
        center.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMinorAlignment(0);
                FlowLayoutExample.this.contents.revalidate();
            }
        });
        right = new Button((Composite)minor, 16);
        right.setText("Buttom/Right");
        right.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMinorAlignment(2);
                FlowLayoutExample.this.contents.revalidate();
            }
        });
        spacing = new Scale((Composite)minor, 0);
        spacing.setMinimum(0);
        spacing.setMaximum(20);
        spacing.setSelection(5);
        spacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMinorSpacing(spacing.getSelection());
                FlowLayoutExample.this.contents.revalidate();
            }
        });
        spacingLabel = new Label((Composite)minor, 0x1000000);
        spacingLabel.setText("Spacing");
    }
}

