/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.visualization.google.internal;

import java.io.IOException;
import org.eclipse.rap.rwt.visualization.google.VisualizationWidget;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class VisualizationWidgetLCA
extends AbstractWidgetLCA {
    protected static final String REDRAW_FUNC = "redraw";
    protected static final String PROP_DATA = "widgetData";
    protected static final String PROP_OPTIONS = "widgetOptions";

    public abstract Class getWidgetType();

    public void renderInitialization(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)widget);
        String id = WidgetUtil.getId((Widget)widget);
        writer.newWidget(this.getWidgetType().getName(), new Object[]{id});
        writer.set("appearance", "composite");
        writer.set("overflow", "hidden");
        ControlLCAUtil.writeStyleFlags((Control)((Control)widget));
    }

    public void preserveValues(Widget widget) {
        ControlLCAUtil.preserveValues((Control)((Control)widget));
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_OPTIONS, (Object)((VisualizationWidget)widget).getWidgetOptions());
        adapter.preserve(PROP_DATA, (Object)((VisualizationWidget)widget).getWidgetData());
    }

    public void renderChanges(Widget widget) throws IOException {
        VisualizationWidget vWidget = (VisualizationWidget)widget;
        ControlLCAUtil.writeChanges((Control)vWidget);
        JSWriter writer = JSWriter.getWriterFor((Widget)vWidget);
        writer.set(PROP_OPTIONS, PROP_OPTIONS, (Object)vWidget.getWidgetOptions());
        writer.set(PROP_DATA, PROP_DATA, (Object)vWidget.getWidgetData());
        if (vWidget.isDirty()) {
            writer.call(REDRAW_FUNC, null);
            vWidget.setDirty(false);
        }
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)widget);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    public void readData(Widget widget) {
        if (widget == null) {
            return;
        }
        VisualizationWidget visWidget = (VisualizationWidget)widget;
        String selectedItem = WidgetLCAUtil.readPropertyValue((Widget)visWidget, (String)"selectedItem");
        String selectedRow = WidgetLCAUtil.readPropertyValue((Widget)visWidget, (String)"selectedRow");
        String selectedColumn = WidgetLCAUtil.readPropertyValue((Widget)visWidget, (String)"selectedColumn");
        String selectedValue = WidgetLCAUtil.readPropertyValue((Widget)visWidget, (String)"selectedValue");
        if (selectedItem != null) {
            visWidget.setSelectedItem(selectedItem);
            visWidget.setSelectedRow(selectedRow);
            visWidget.setSelectedColumn(selectedColumn);
            visWidget.setSelectedValue(selectedValue);
            ControlLCAUtil.processSelection((Widget)visWidget, null, (boolean)true);
        }
    }
}

