/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.gef.demo;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.draw2d.examples.cg.ObstructionExample;
import org.eclipse.draw2d.examples.connections.ConnectionAndAnchorExample;
import org.eclipse.draw2d.examples.graph.CompoundGraphDemo;
import org.eclipse.draw2d.examples.graph.DirectedGraphDemo;
import org.eclipse.draw2d.examples.layouts.FlowLayoutExample;
import org.eclipse.draw2d.examples.layouts.GridLayoutExample;
import org.eclipse.draw2d.examples.layouts.ToolbarLayoutExample;
import org.eclipse.draw2d.examples.scrollpane.ScrollPaneExample;
import org.eclipse.draw2d.examples.tree.SimpleTreeExample;
import org.eclipse.draw2d.examples.tree.TreeExample;
import org.eclipse.gef.examples.flow.ui.FlowEditorView;
import org.eclipse.gef.examples.logicdesigner.LogicEditorView;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rap.gef.demo.ApplicationWorkbenchAdvisor;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.part.ViewPart;

public class Application
implements IEntryPoint {
    public int createUI() {
        Display display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
        return 0;
    }

    public static class Draw2DExampleView
    extends ViewPart {
        private Map examples;
        private Map controls;
        private StackLayout layout;
        private Composite demoContent;

        public void createPartControl(Composite parent) {
            UICallBack.activate((String)(String.valueOf(this.getSite().getId()) + this.getViewSite().getSecondaryId()));
            SashForm form = new SashForm(parent, 256);
            ListViewer exampleList = new ListViewer((Composite)form, 2560);
            exampleList.setContentProvider((IContentProvider)new ArrayContentProvider());
            exampleList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.examples = new TreeMap();
            this.controls = new HashMap();
            this.demoContent = new Composite((Composite)form, 2048);
            this.layout = new StackLayout();
            this.demoContent.setLayout((Layout)this.layout);
            this.layout.topControl = new Composite(this.demoContent, 0);
            this.demoContent.update();
            this.demoContent.layout(true);
            this.examples.put("Compound Graph", new Runnable(){

                public void run() {
                    new CompoundGraphDemo().run(Draw2DExampleView.this.demoContent);
                }
            });
            this.examples.put("Directed Graph", new Runnable(){

                public void run() {
                    new DirectedGraphDemo().run(Draw2DExampleView.this.demoContent);
                }
            });
            this.examples.put("Connection and Anchor", new Runnable(){

                public void run() {
                    new ConnectionAndAnchorExample().run(Draw2DExampleView.this.demoContent);
                }
            });
            this.examples.put("Obstruction", new Runnable(){

                public void run() {
                    new ObstructionExample().run(Draw2DExampleView.this.demoContent);
                }
            });
            this.examples.put("Flow Layout", new Runnable(){

                public void run() {
                    new FlowLayoutExample().run(Draw2DExampleView.this.demoContent);
                }
            });
            this.examples.put("Grid Layout", new Runnable(){

                public void run() {
                    new GridLayoutExample().run(Draw2DExampleView.this.demoContent);
                }
            });
            this.examples.put("Toolbar Layout", new Runnable(){

                public void run() {
                    new ToolbarLayoutExample().run(Draw2DExampleView.this.demoContent);
                }
            });
            this.examples.put("Scroll Pane", new Runnable(){

                public void run() {
                    new ScrollPaneExample().run(Draw2DExampleView.this.demoContent);
                }
            });
            this.examples.put("Tree", new Runnable(){

                public void run() {
                    new TreeExample().run(Draw2DExampleView.this.demoContent);
                }
            });
            this.examples.put("Simple Tree", new Runnable(){

                public void run() {
                    new SimpleTreeExample().run(Draw2DExampleView.this.demoContent);
                }
            });
            exampleList.setInput(this.examples.keySet());
            exampleList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object selElem = selection.getFirstElement();
                    Object ctrl = Draw2DExampleView.this.controls.get(selElem);
                    if (ctrl == null) {
                        Runnable runner = (Runnable)Draw2DExampleView.this.examples.get(selElem);
                        runner.run();
                        Control[] children = Draw2DExampleView.this.demoContent.getChildren();
                        ctrl = children[children.length - 1];
                        Draw2DExampleView.this.controls.put(selElem, ctrl);
                    }
                    ((Draw2DExampleView)Draw2DExampleView.this).layout.topControl = (Control)ctrl;
                    Draw2DExampleView.this.demoContent.update();
                    Draw2DExampleView.this.demoContent.layout(true);
                }
            });
            form.setWeights(new int[]{1, 3});
        }

        public void setFocus() {
        }

        public void dispose() {
            UICallBack.deactivate((String)(String.valueOf(this.getSite().getId()) + this.getViewSite().getSecondaryId()));
            super.dispose();
        }
    }

    public static class FlowExampleView
    extends FlowEditorView {
    }

    public static class LogicExampleView
    extends LogicEditorView {
    }
}

