/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.AndGate;
import org.eclipse.gef.examples.logicdesigner.model.Circuit;
import org.eclipse.gef.examples.logicdesigner.model.GroundOutput;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.examples.logicdesigner.model.LiveOutput;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagramFactory;
import org.eclipse.gef.examples.logicdesigner.model.LogicFlowContainer;
import org.eclipse.gef.examples.logicdesigner.model.LogicLabel;
import org.eclipse.gef.examples.logicdesigner.model.OrGate;
import org.eclipse.gef.examples.logicdesigner.model.XORGate;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LogicPlugin
extends AbstractUIPlugin {
    private static LogicPlugin singleton;

    private static List createCategories(PaletteRoot root) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(LogicPlugin.createControlGroup(root));
        categories.add(LogicPlugin.createComponentsDrawer());
        categories.add(LogicPlugin.createComplexPartsDrawer());
        return categories;
    }

    private static PaletteContainer createComplexPartsDrawer() {
        PaletteDrawer drawer = new PaletteDrawer(LogicMessages.LogicPlugin_Category_ComplexParts_Label, ImageDescriptor.createFromFile(Circuit.class, (String)"icons/can.gif"));
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_HalfAdder_Label, LogicMessages.LogicPlugin_Tool_CreationTool_HalfAdder_Description, LogicDiagramFactory.getHalfAdderFactory(), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/halfadder16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/halfadder24.gif"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_FullAdder_Label, LogicMessages.LogicPlugin_Tool_CreationTool_FullAdder_Description, LogicDiagramFactory.getFullAdderFactory(), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/fulladder16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/fulladder24.gif"));
        entries.add(combined);
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createComponentsDrawer() {
        PaletteDrawer drawer = new PaletteDrawer(LogicMessages.LogicPlugin_Category_Components_Label, ImageDescriptor.createFromFile(Circuit.class, (String)"icons/comp.gif"));
        ArrayList<Object> entries = new ArrayList<Object>();
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_FlowContainer_Label, LogicMessages.LogicPlugin_Tool_CreationTool_FlowContainer_Description, (CreationFactory)new SimpleFactory(LogicFlowContainer.class), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/logicflow16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/logicflow24.gif"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_Circuit_Label, LogicMessages.LogicPlugin_Tool_CreationTool_Circuit_Description, (CreationFactory)new SimpleFactory(Circuit.class), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/circuit16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/circuit24.gif"));
        entries.add(combined);
        entries.add(new PaletteSeparator());
        combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_Label_Label, LogicMessages.LogicPlugin_Tool_CreationTool_Label_Description, (CreationFactory)new SimpleFactory(LogicLabel.class), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/label16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/label24.gif"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_LED_Label, LogicMessages.LogicPlugin_Tool_CreationTool_LED_Description, (CreationFactory)new SimpleFactory(LED.class), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/ledicon16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/ledicon24.gif"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_ORGate_Label, LogicMessages.LogicPlugin_Tool_CreationTool_ORGate_Description, (CreationFactory)new SimpleFactory(OrGate.class), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/or16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/or24.gif"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_XORGate_Label, LogicMessages.LogicPlugin_Tool_CreationTool_XORGate_Description, (CreationFactory)new SimpleFactory(XORGate.class), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/xor16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/xor24.gif"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_ANDGate_Label, LogicMessages.LogicPlugin_Tool_CreationTool_ANDGate_Description, (CreationFactory)new SimpleFactory(AndGate.class), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/and16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/and24.gif"));
        entries.add(combined);
        PaletteStack liveGroundStack = new PaletteStack(LogicMessages.LogicPlugin_Tool_CreationTool_LiveGroundStack_Label, LogicMessages.LogicPlugin_Tool_CreationTool_LiveGroundStack_Description, null);
        combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_LiveOutput_Label, LogicMessages.LogicPlugin_Tool_CreationTool_LiveOutput_Description, (CreationFactory)new SimpleFactory(LiveOutput.class), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/live16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/live24.gif"));
        liveGroundStack.add((PaletteEntry)combined);
        combined = new CombinedTemplateCreationEntry(LogicMessages.LogicPlugin_Tool_CreationTool_Ground_Label, LogicMessages.LogicPlugin_Tool_CreationTool_Ground_Description, (CreationFactory)new SimpleFactory(GroundOutput.class), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/ground16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/ground24.gif"));
        liveGroundStack.add((PaletteEntry)combined);
        entries.add(liveGroundStack);
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup(LogicMessages.LogicPlugin_Category_ControlGroup_Label);
        ArrayList<Object> entries = new ArrayList<Object>();
        PanningSelectionToolEntry tool = new PanningSelectionToolEntry();
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        PaletteStack marqueeStack = new PaletteStack(LogicMessages.Marquee_Stack, "", null);
        marqueeStack.add((PaletteEntry)new MarqueeToolEntry());
        MarqueeToolEntry marquee = new MarqueeToolEntry();
        marquee.setToolProperty(MarqueeSelectionTool.PROPERTY_MARQUEE_BEHAVIOR, (Object)new Integer(MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED));
        marqueeStack.add((PaletteEntry)marquee);
        marquee = new MarqueeToolEntry();
        marquee.setToolProperty(MarqueeSelectionTool.PROPERTY_MARQUEE_BEHAVIOR, (Object)new Integer(MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED | MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED));
        marqueeStack.add((PaletteEntry)marquee);
        marqueeStack.setUserModificationPermission(1);
        entries.add(marqueeStack);
        tool = new ConnectionCreationToolEntry(LogicMessages.LogicPlugin_Tool_ConnectionCreationTool_ConnectionCreationTool_Label, LogicMessages.LogicPlugin_Tool_ConnectionCreationTool_ConnectionCreationTool_Description, null, ImageDescriptor.createFromFile(Circuit.class, (String)"icons/connection16.gif"), ImageDescriptor.createFromFile(Circuit.class, (String)"icons/connection24.gif"));
        entries.add(tool);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    static PaletteRoot createPalette() {
        PaletteRoot logicPalette = new PaletteRoot();
        logicPalette.addAll(LogicPlugin.createCategories(logicPalette));
        return logicPalette;
    }

    public static LogicPlugin getDefault() {
        return singleton;
    }

    public LogicPlugin() {
        if (singleton == null) {
            singleton = this;
        }
    }
}

