/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.tree;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.examples.tree.TreeBranch;
import org.eclipse.draw2d.geometry.Transposer;

public class TreeRoot
extends TreeBranch {
    private int major = 10;
    private int minor = 10;
    private Transposer transposer = new Transposer();
    private boolean compression;

    public TreeRoot(IFigure title) {
        super(title);
    }

    public TreeRoot(IFigure title, int style) {
        super(title, style);
    }

    public int getMajorSpacing() {
        return this.major;
    }

    public int getMinorSpacing() {
        return this.minor;
    }

    public TreeRoot getRoot() {
        return this;
    }

    public Transposer getTransposer() {
        return this.transposer;
    }

    public boolean isHorizontal() {
        return !this.transposer.isEnabled();
    }

    public void setMajorSpacing(int value) {
        this.major = value;
        this.invalidateTree();
        this.revalidate();
    }

    public void setHorizontal(boolean value) {
        this.transposer.setEnabled(!value);
        this.invalidateTree();
        this.revalidate();
    }

    public void setMinorSpacing(int i) {
        this.minor = i;
        this.invalidateTree();
        this.revalidate();
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.setRowHeights(this.getPreferredRowHeights(), 0);
        super.validate();
    }

    public boolean isCompressed() {
        return this.compression;
    }

    public void setCompression(boolean b) {
        this.compression = b;
    }
}

