/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.tree;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.examples.tree.Animation;
import org.eclipse.draw2d.examples.tree.BranchLayout;
import org.eclipse.draw2d.examples.tree.TreeBranch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

class NormalLayout
extends BranchLayout {
    NormalLayout(TreeBranch branch) {
        super(branch);
    }

    void calculateDepth() {
        this.depth = 0;
        List subtrees = this.getSubtrees();
        int i = 0;
        while (i < subtrees.size()) {
            this.depth = Math.max(this.depth, ((TreeBranch)((Object)subtrees.get(i))).getDepth());
            ++i;
        }
        ++this.depth;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Rectangle union = this.branch.getNodeBounds().getCopy();
        union.union(this.branch.getContentsPane().getBounds());
        return union.getSize();
    }

    public void layout(IFigure f) {
        Animation.recordInitialState(f);
        if (Animation.playbackState(f)) {
            return;
        }
        Transposer transposer = this.getTransposer();
        IFigure contents = this.branch.getContentsPane();
        IFigure node = this.branch.getNode();
        contents.validate();
        Rectangle branchBounds = transposer.t(this.branch.getBounds());
        Point topLeft = branchBounds.getTopLeft();
        Rectangle nodeLocation = new Rectangle(topLeft, transposer.t(node.getPreferredSize()));
        nodeLocation.height = this.rowHeight - this.getMajorSpacing();
        if (!contents.isVisible() || contents.getChildren().isEmpty()) {
            nodeLocation.x += (branchBounds.width - nodeLocation.width) / 2;
            node.setBounds(transposer.t(nodeLocation));
            contents.setBounds(transposer.t(nodeLocation.getTranslated(0, this.rowHeight).setSize(0, 0)));
            return;
        }
        Rectangle contentsLocation = new Rectangle(topLeft, transposer.t(contents.getPreferredSize()));
        contents.setSize(contents.getPreferredSize());
        contentsLocation.y += this.rowHeight;
        TreeBranch firstChild = (TreeBranch)((Object)contents.getChildren().get(0));
        TreeBranch lastChild = (TreeBranch)((Object)contents.getChildren().get(contents.getChildren().size() - 1));
        int leftInset = firstChild.getContourLeft()[0] + transposer.t((Rectangle)firstChild.getBounds()).x - transposer.t((Rectangle)contents.getBounds()).x;
        int rightInset = lastChild.getContourRight()[0] - transposer.t(lastChild.getBounds()).right() + transposer.t(contents.getBounds()).right();
        rightInset = Math.max(rightInset, 0);
        leftInset = Math.max(leftInset, 0);
        int childrenSpan = contentsLocation.width - leftInset - rightInset;
        switch (this.branch.getAlignment()) {
            case 2: {
                leftInset += (childrenSpan - nodeLocation.width) / 2;
            }
        }
        if (leftInset > 0) {
            nodeLocation.x += leftInset;
        } else {
            contentsLocation.x -= leftInset;
        }
        int adjust = branchBounds.width - Rectangle.SINGLETON.setBounds((Rectangle)contentsLocation).union((Rectangle)nodeLocation).width;
        nodeLocation.x += (adjust /= 2);
        contentsLocation.x += adjust;
        node.setBounds(transposer.t(nodeLocation));
        contents.setBounds(transposer.t(contentsLocation));
    }

    void mergeContour(int[] destination, int[] source, int startdepth, int offset) {
        int i = startdepth;
        while (i < source.length) {
            destination[i + 1] = source[i] + offset;
            ++i;
        }
    }

    void paintLines(Graphics g) {
        if (this.getTransposer().isEnabled()) {
            IFigure node = this.branch.getNode();
            int left = node.getBounds().right();
            int right = this.branch.getContentsPane().getBounds().x - 1;
            int yMid = node.getBounds().getCenter().y;
            int xMid = (left + right) / 2;
            List children = this.getSubtrees();
            if (children.size() == 0) {
                return;
            }
            g.drawLine(left, yMid, xMid, yMid);
            int yMin = yMid;
            int yMax = yMid;
            int i = 0;
            while (i < children.size()) {
                int y = ((TreeBranch)((Object)children.get((int)i))).getNodeBounds().getCenter().y;
                g.drawLine(xMid, y, right, y);
                yMin = Math.min(yMin, y);
                yMax = Math.max(yMax, y);
                ++i;
            }
            g.drawLine(xMid, yMin, xMid, yMax);
        } else {
            IFigure node = this.branch.getNode();
            int xMid = node.getBounds().getCenter().x;
            int top = node.getBounds().bottom();
            int bottom = this.branch.getContentsPane().getBounds().y - 1;
            int yMid = (top + bottom) / 2;
            List children = this.getSubtrees();
            if (children.size() == 0) {
                return;
            }
            g.drawLine(xMid, top, xMid, yMid);
            int xMin = xMid;
            int xMax = xMid;
            int i = 0;
            while (i < children.size()) {
                int x = ((TreeBranch)((Object)children.get((int)i))).getNodeBounds().getCenter().x;
                g.drawLine(x, yMid, x, bottom);
                xMin = Math.min(xMin, x);
                xMax = Math.max(xMax, x);
                ++i;
            }
            g.drawLine(xMin, yMid, xMax, yMid);
        }
    }

    void updateContours() {
        TreeBranch subtree;
        Transposer transposer = this.getTransposer();
        this.branch.validate();
        this.cachedContourLeft = new int[this.getDepth()];
        this.cachedContourRight = new int[this.getDepth()];
        Rectangle clientArea = transposer.t(this.branch.getNodeBounds().getUnion(this.branch.contents.getBounds()));
        Rectangle nodeBounds = transposer.t(this.branch.getNodeBounds());
        transposer.t(this.branch.getContentsPane().getBounds());
        this.cachedContourLeft[0] = nodeBounds.x - clientArea.x;
        this.cachedContourRight[0] = clientArea.right() - nodeBounds.right();
        if (!this.branch.isExpanded()) {
            return;
        }
        List subtrees = this.getSubtrees();
        int currentDepth = 0;
        int i = 0;
        while (i < subtrees.size() && currentDepth < this.getDepth()) {
            subtree = (TreeBranch)((Object)subtrees.get(i));
            if (subtree.getDepth() > currentDepth) {
                int[] leftContour = subtree.getContourLeft();
                int leftOffset = transposer.t((Rectangle)subtree.getBounds()).x - clientArea.x;
                this.mergeContour(this.cachedContourLeft, leftContour, currentDepth, leftOffset);
                currentDepth = subtree.getDepth();
            }
            ++i;
        }
        currentDepth = 0;
        i = subtrees.size() - 1;
        while (i >= 0 && currentDepth < this.getDepth()) {
            subtree = (TreeBranch)((Object)subtrees.get(i));
            if (subtree.getDepth() > currentDepth) {
                int[] rightContour = subtree.getContourRight();
                int rightOffset = clientArea.right() - transposer.t(subtree.getBounds()).right();
                this.mergeContour(this.cachedContourRight, rightContour, currentDepth, rightOffset);
                currentDepth = subtree.getDepth();
            }
            --i;
        }
    }

    void updateRowHeights() {
        Transposer transposer = this.getTransposer();
        this.preferredRowHeights = new int[this.getDepth()];
        this.preferredRowHeights[0] = transposer.t((Dimension)this.branch.getNode().getPreferredSize()).height + this.getMajorSpacing();
        if (!this.branch.isExpanded()) {
            return;
        }
        List subtrees = this.getSubtrees();
        int i = 0;
        while (i < subtrees.size()) {
            TreeBranch subtree = (TreeBranch)((Object)subtrees.get(i));
            int[] rowHeights = subtree.getPreferredRowHeights();
            int row = 0;
            while (row < rowHeights.length) {
                this.preferredRowHeights[row + 1] = Math.max(this.preferredRowHeights[row + 1], rowHeights[row]);
                ++row;
            }
            ++i;
        }
    }

    void setRowHeights(int[] heights, int offset) {
        super.setRowHeights(heights, offset);
        if (this.branch.isExpanded()) {
            List subtrees = this.getSubtrees();
            ++offset;
            int i = 0;
            while (i < subtrees.size()) {
                ((TreeBranch)((Object)subtrees.get(i))).setRowHeights(heights, offset);
                ++i;
            }
        }
    }
}

