/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.text;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.SimpleTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Font;

public class TextFlowExample
extends AbstractExample {
    protected static IFigure createAlignmentParagraph() {
        BlockFlow block = new BlockFlow();
        block.setHorizontalAligment(4);
        block.add((IFigure)new TextFlow("An inline flow figure's aligment is determined by the block flow in which it resides. This block is aligned using "));
        TextFlow text = new TextFlow("PositionConstants.RIGHT");
        text.setFont(COURIER);
        block.add((IFigure)text);
        block.add((IFigure)new TextFlow(", which results in right text aligment"));
        return block;
    }

    protected static IFigure createBaselineParagraph() {
        BlockFlow block = new BlockFlow();
        String[] message = new String[]{"Text fragments ", "with different ", "Font sizes will ", "have their ", "baseline ", "vertically ", "aligned ", "within ", "the current ", "line"};
        int i = 0;
        while (i < message.length) {
            TextFlow tf = new TextFlow(message[i]);
            tf.setFont(new Font(null, "Helvetica", i + 8, 0));
            block.add((IFigure)tf);
            ++i;
        }
        return block;
    }

    protected static IFigure createBlockParagraph() {
        BlockFlow blockFlow = new BlockFlow();
        blockFlow.setFont(COURIER);
        TextFlow contents = new TextFlow();
        contents.setLayoutManager((LayoutManager)new SimpleTextLayout(contents));
        contents.setText("/**\n * The SimpleTextLayout only breaks at newlines\n * It can be used to render source code.\r */\r\npublic void foo() {\n    //TABs are not handled currently, only spaces.\n    System.out.println(\"foo\")\n}");
        blockFlow.add((IFigure)contents);
        return blockFlow;
    }

    protected static IFigure createNestedInlineParagraph() {
        BlockFlow blockFlow = new BlockFlow();
        blockFlow.add((IFigure)new TextFlow("A paragraph can contain multiple children, including nested structure using InlineFlows. "));
        InlineFlow inline = new InlineFlow();
        inline.setForegroundColor(ColorConstants.darkBlue);
        inline.add((IFigure)new TextFlow("This TextFlow is inside an InlineFlow with a blue foreground color. Children can have "));
        TextFlow text = new TextFlow("Bold ");
        text.setFont(BOLD);
        inline.add((IFigure)text);
        inline.add((IFigure)new TextFlow("or "));
        text = new TextFlow("Italic ");
        text.setFont(ITALICS);
        inline.add((IFigure)text);
        inline.add((IFigure)new TextFlow("Font, or override other inherited attributes."));
        blockFlow.add((IFigure)inline);
        return blockFlow;
    }

    protected static IFigure createParagraph() {
        BlockFlow blockFlow = new BlockFlow();
        TextFlow contents = new TextFlow();
        contents.setText("A paragraph is created by using a BlockFlow figure. A paragraph usually wraps to the width of the current page. To see this, try resizing the example's window. The contents of this paragraph were created using a TextFlow figure in its default layout, which breaks at whitespace. a block of text that doesn't wrap can be created by using the SimpleTextLayout on a TextFlow");
        blockFlow.add((IFigure)contents);
        return blockFlow;
    }

    protected static IFigure createTitle() {
        BlockFlow blockFlow = new BlockFlow();
        TextFlow contents = new TextFlow("Draw2D TextFlow Example");
        contents.setFont(HEADING_1);
        blockFlow.add((IFigure)contents);
        return blockFlow;
    }

    protected IFigure getContents() {
        FlowPage page = new FlowPage();
        page.setOpaque(true);
        page.setBackgroundColor(ColorConstants.white);
        page.add(TextFlowExample.createTitle());
        page.add(TextFlowExample.createParagraph());
        page.add(TextFlowExample.createBlockParagraph());
        page.add(TextFlowExample.createNestedInlineParagraph());
        page.add(TextFlowExample.createBaselineParagraph());
        page.add(TextFlowExample.createAlignmentParagraph());
        return page;
    }

    public static void main(String[] args) {
        new TextFlowExample().run();
    }

    protected void setFigureCanvas(FigureCanvas canvas) {
        super.setFigureCanvas(canvas);
        canvas.getViewport().setContentsTracksWidth(true);
    }
}

