/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.graph;

import java.util.Random;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;

public class GraphTests {
    static Random rand = new Random(90L);

    public static DirectedGraph offsetTest() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node head = new Node((Object)"Head");
        nodes.add((Object)head);
        head.width = 100;
        Node a1 = new Node((Object)"node a1");
        nodes.add((Object)a1);
        Node a2 = new Node((Object)"node a2");
        nodes.add((Object)a2);
        Node a3 = new Node((Object)"node a3");
        nodes.add((Object)a3);
        Node a4 = new Node((Object)"node a4");
        nodes.add((Object)a4);
        Node b1 = new Node((Object)"node b1");
        nodes.add((Object)b1);
        Node b2 = new Node((Object)"node b2");
        nodes.add((Object)b2);
        Node b3 = new Node((Object)"node b3");
        nodes.add((Object)b3);
        Node b4 = new Node((Object)"node b4");
        nodes.add((Object)b4);
        Edge e = new Edge(head, a1);
        e.setSourceOffset(10);
        edges.add((Object)e);
        e = new Edge(head, b1);
        e.setSourceOffset(90);
        edges.add((Object)e);
        a1.incomingOffset = 40;
        b1.incomingOffset = 10;
        a1.outgoingOffset = 10;
        a2.incomingOffset = 40;
        a3.outgoingOffset = 10;
        a4.incomingOffset = 40;
        edges.add((Object)new Edge(b1, b2));
        edges.add((Object)new Edge(b2, b3));
        edges.add((Object)new Edge(b3, b4));
        edges.add((Object)new Edge(a1, a2));
        e = new Edge(a2, a3);
        edges.add((Object)e);
        e.setSourceOffset(10);
        e.setTargetOffset(40);
        edges.add((Object)new Edge(a3, a4));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    private static void addNodes(NodeList nodes, Node[] row) {
        int i = 0;
        while (i < row.length) {
            if (row[i] != null) {
                nodes.add((Object)row[i]);
            }
            ++i;
        }
    }

    public static DirectedGraph anotherTour() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node[] firstRow = new Node[4];
        firstRow[1] = new Node((Object)"h1");
        firstRow[2] = new Node((Object)"h2");
        firstRow[3] = new Node((Object)"h3");
        GraphTests.addNodes(nodes, firstRow);
        Node[] row = GraphTests.joinRows(nodes, edges, firstRow, new int[]{1, 1, 1, 2, 1, 3, 2, 3, 2, 4, 3, 3, 3, 4});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 3, 4, 2, 1, 2, 3, 3, 2, 4, 4});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 1, 2, 2, 1, 2, 4, 3, 3, 3, 4, 4, 3, 4, 5});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 1, 2, 4, 3, 5, 4});
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph balanceThis1() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node b1 = new Node((Object)"node b1");
        nodes.add((Object)b1);
        Node b2 = new Node((Object)"node b2");
        nodes.add((Object)b2);
        Node b3 = new Node((Object)"node b3");
        nodes.add((Object)b3);
        Node b4 = new Node((Object)"node b4");
        nodes.add((Object)b4);
        Node b5 = new Node((Object)"node b5");
        nodes.add((Object)b5);
        Node c = new Node((Object)"node c");
        nodes.add((Object)c);
        Node d = new Node((Object)"node d");
        nodes.add((Object)d);
        Node e = new Node((Object)"node e");
        nodes.add((Object)e);
        Node f = new Node((Object)"node f");
        nodes.add((Object)f);
        Node g = new Node((Object)"node g");
        nodes.add((Object)g);
        Node a = new Node((Object)"node a");
        nodes.add((Object)a);
        b2.width = 90;
        b3.width = 90;
        edges.add((Object)new Edge(c, d));
        edges.add((Object)new Edge(c, e));
        edges.add((Object)new Edge(e, f));
        edges.add((Object)new Edge(e, g));
        edges.add((Object)new Edge(a, b1));
        edges.add((Object)new Edge(a, b2));
        edges.add((Object)new Edge(a, b3));
        edges.add((Object)new Edge(a, b4));
        edges.add((Object)new Edge(a, b5));
        edges.add((Object)new Edge(b3, d));
        edges.add((Object)new Edge(b4, f));
        edges.add((Object)new Edge(a, c));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph balanceThis2() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node b2 = new Node((Object)"node b2");
        nodes.add((Object)b2);
        Node b3 = new Node((Object)"node b3");
        nodes.add((Object)b3);
        Node b4 = new Node((Object)"node b4");
        nodes.add((Object)b4);
        Node c = new Node((Object)"node c");
        nodes.add((Object)c);
        Node d = new Node((Object)"node d");
        nodes.add((Object)d);
        Node e = new Node((Object)"node e");
        nodes.add((Object)e);
        Node f = new Node((Object)"node f");
        nodes.add((Object)f);
        Node g = new Node((Object)"node g");
        nodes.add((Object)g);
        Node a = new Node((Object)"node a");
        nodes.add((Object)a);
        edges.add((Object)new Edge(d, c));
        edges.add((Object)new Edge(e, c));
        edges.add((Object)new Edge(f, e));
        edges.add((Object)new Edge(g, e));
        edges.add((Object)new Edge(b2, a));
        edges.add((Object)new Edge(b3, a));
        edges.add((Object)new Edge(b4, a, 1, 2));
        edges.add((Object)new Edge(d, b3));
        edges.add((Object)new Edge(f, b4));
        edges.add((Object)new Edge(c, a));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph balanceThis3() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node top1 = new Node((Object)"Top 1");
        nodes.add((Object)top1);
        top1.width = 400;
        Node top2 = new Node((Object)"Top 2");
        nodes.add((Object)top2);
        top2.width = 400;
        Node a1 = new Node((Object)"a1");
        nodes.add((Object)a1);
        Node a2 = new Node((Object)"a2");
        nodes.add((Object)a2);
        Node a3 = new Node((Object)"a3");
        nodes.add((Object)a3);
        Node a4 = new Node((Object)"a4");
        nodes.add((Object)a4);
        Node b1 = new Node((Object)"b1");
        nodes.add((Object)b1);
        Node b2 = new Node((Object)"b2");
        nodes.add((Object)b2);
        Node b3 = new Node((Object)"b3");
        nodes.add((Object)b3);
        Node b4 = new Node((Object)"b4");
        nodes.add((Object)b4);
        Node b5 = new Node((Object)"b5");
        nodes.add((Object)b5);
        Node b6 = new Node((Object)"b6");
        nodes.add((Object)b6);
        Node c1 = new Node((Object)"c1");
        nodes.add((Object)c1);
        Node c2 = new Node((Object)"c2");
        nodes.add((Object)c2);
        Node c3 = new Node((Object)"c3");
        nodes.add((Object)c3);
        Node c4 = new Node((Object)"c4");
        nodes.add((Object)c4);
        Node bottom1 = new Node((Object)"Bottom 1");
        nodes.add((Object)bottom1);
        bottom1.width = 400;
        Node bottom2 = new Node((Object)"Bottom 2");
        nodes.add((Object)bottom2);
        bottom2.width = 400;
        edges.add((Object)new Edge(top1, a1));
        edges.add((Object)new Edge(top2, a4));
        edges.add((Object)new Edge(a1, b1));
        edges.add((Object)new Edge(a2, b1));
        edges.add((Object)new Edge(a2, b3));
        edges.add((Object)new Edge(a3, b3));
        edges.add((Object)new Edge(a3, b5));
        edges.add((Object)new Edge(a4, b5));
        edges.add((Object)new Edge(a4, b6));
        edges.add((Object)new Edge(b1, c1));
        edges.add((Object)new Edge(b2, c1));
        edges.add((Object)new Edge(b2, c2));
        edges.add((Object)new Edge(b4, c2));
        edges.add((Object)new Edge(b4, c3));
        edges.add((Object)new Edge(b6, c3));
        edges.add((Object)new Edge(b6, c4));
        edges.add((Object)new Edge(c1, bottom1));
        edges.add((Object)new Edge(c4, bottom2));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph fourLevelBinaryTree() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node[] firstRow = new Node[2];
        firstRow[1] = new Node((Object)"root");
        GraphTests.addNodes(nodes, firstRow);
        Node[] row = GraphTests.joinRows(nodes, edges, firstRow, new int[]{1, 1, 1, 2});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 1, 2, 2, 3, 2, 4});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 1, 2, 2, 3, 2, 4, 3, 5, 3, 6, 4, 7, 4, 8});
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph graph1() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node[] firstRow = new Node[3];
        firstRow[1] = new Node((Object)"h1");
        firstRow[2] = new Node((Object)"h2");
        GraphTests.addNodes(nodes, firstRow);
        Node[] row = GraphTests.joinRows(nodes, edges, firstRow, new int[]{1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 2, 7, 2, 8, 2, 9, 2, 10});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 2, 2, 2, 3, 3, 1, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 1, 2, 2, 3, 2, 6, 3, 6, 4, 4, 5, 5, 6, 7, 7, 6, 8, 8, 9, 6, 10, 9, 10, 10, 11, 11});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 1, 2, 1, 3, 2, 3, 3, 4, 4, 5, 5, 6, 7, 3, 8, 7, 9, 8, 10, 9, 10, 10, 11, 11});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 2, 2, 4, 3, 5, 4, 6, 5, 7, 6, 8, 7, 9, 7, 10, 7, 11, 7});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 2, 2, 3, 4, 4, 4, 5, 3, 6, 4, 7, 4, 7, 5});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 2, 2, 1, 3, 2, 4, 2, 4, 3, 5, 4});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 2, 1, 3, 1, 4, 1});
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph graph2() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node[] firstRow = new Node[5];
        firstRow[1] = new Node((Object)"h1");
        firstRow[2] = new Node((Object)"h2");
        firstRow[3] = new Node((Object)"h3");
        firstRow[4] = new Node((Object)"h4");
        firstRow[4].width = 160;
        firstRow[3].width = 160;
        firstRow[2].width = 160;
        firstRow[1].width = 160;
        GraphTests.addNodes(nodes, firstRow);
        Node[] row = GraphTests.joinRows(nodes, edges, firstRow, new int[]{1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 3, 3, 5, 2});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 2, 2});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 1, 2, 2, 2, 2, 1});
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph graph3() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node[] firstRow = new Node[4];
        firstRow[1] = new Node((Object)"h1");
        firstRow[2] = new Node((Object)"h2");
        firstRow[3] = new Node((Object)"h3");
        firstRow[3].width = 120;
        firstRow[2].width = 120;
        firstRow[1].width = 120;
        GraphTests.addNodes(nodes, firstRow);
        Node[] row = GraphTests.joinRows(nodes, edges, firstRow, new int[]{1, 1, 1, 2, 1, 3, 2, 3, 2, 4, 3, 3, 3, 4});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 3, 4, 2, 1, 2, 3, 3, 2, 4, 4});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 1, 2, 2, 1, 2, 4, 3, 3, 3, 4, 4, 3, 4, 5});
        row = GraphTests.joinRows(nodes, edges, row, new int[]{1, 1, 2, 2, 4, 4, 5, 5, 1, 2, 4, 3, 5, 4});
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    private static Node[] joinRows(NodeList nodes, EdgeList edges, Node[] firstRow, int[] conns) {
        GraphTests.shuffleConnections(conns);
        Node[] secondRow = new Node[20];
        int i = 0;
        while (i < conns.length) {
            Node head = firstRow[conns[i]];
            Node tail = secondRow[conns[i + 1]];
            if (tail == null) {
                Node node = new Node((Object)("node" + conns[i + 1]));
                secondRow[conns[i + 1]] = node;
                tail = node;
                tail.width = 78;
            }
            edges.add((Object)new Edge(head, tail));
            i += 2;
        }
        GraphTests.addNodes(nodes, secondRow);
        return secondRow;
    }

    private static void shuffleConnections(int[] conns) {
        int i = 0;
        while (i < conns.length) {
            int swap = (int)(rand.nextFloat() * (float)conns.length) % conns.length / 2;
            int temp = conns[i];
            conns[i] = conns[swap *= 2];
            conns[swap] = temp;
            temp = conns[i + 1];
            conns[i + 1] = conns[swap + 1];
            conns[swap + 1] = temp;
            i += 2;
        }
    }

    public static DirectedGraph simpleGraph() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node a = new Node((Object)"node a");
        nodes.add((Object)a);
        Node e = new Node((Object)"node e");
        nodes.add((Object)e);
        Node b = new Node((Object)"node b");
        nodes.add((Object)b);
        Node c = new Node((Object)"node c");
        nodes.add((Object)c);
        Node d = new Node((Object)"node d");
        nodes.add((Object)d);
        Node x = new Node((Object)"node X");
        nodes.add((Object)x);
        Node f = new Node((Object)"node f");
        nodes.add((Object)f);
        Node g = new Node((Object)"node g");
        nodes.add((Object)g);
        Node h = new Node((Object)"node h");
        nodes.add((Object)h);
        Node i = new Node((Object)"node i");
        nodes.add((Object)i);
        edges.add((Object)new Edge(a, i));
        edges.add((Object)new Edge(i, g));
        edges.add((Object)new Edge(i, h));
        edges.add((Object)new Edge(c, i));
        edges.add((Object)new Edge(a, b));
        edges.add((Object)new Edge(b, c));
        edges.add((Object)new Edge(c, d));
        edges.add((Object)new Edge(d, x));
        edges.add((Object)new Edge(x, e));
        edges.add((Object)new Edge(a, f));
        edges.add((Object)new Edge(f, g));
        edges.add((Object)new Edge(f, h));
        edges.add((Object)new Edge(g, e));
        edges.add((Object)new Edge(h, e));
        edges.add((Object)new Edge(b, g));
        edges.add((Object)new Edge(f, d));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph test1() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node a = new Node((Object)"node a");
        nodes.add((Object)a);
        Node b = new Node((Object)"node b");
        nodes.add((Object)b);
        Node c = new Node((Object)"node c");
        nodes.add((Object)c);
        Node d = new Node((Object)"node d");
        nodes.add((Object)d);
        Node e = new Node((Object)"node e");
        nodes.add((Object)e);
        Node f = new Node((Object)"node f");
        nodes.add((Object)f);
        Node g = new Node((Object)"node g");
        nodes.add((Object)g);
        edges.add((Object)new Edge(a, d));
        edges.add((Object)new Edge(b, d));
        edges.add((Object)new Edge(c, d));
        edges.add((Object)new Edge(d, e));
        edges.add((Object)new Edge(d, f));
        edges.add((Object)new Edge(d, g));
        edges.add((Object)new Edge(c, g));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph test2() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node a = new Node((Object)"node a");
        nodes.add((Object)a);
        Node b = new Node((Object)"node b");
        nodes.add((Object)b);
        Node c = new Node((Object)"node c");
        nodes.add((Object)c);
        Node d = new Node((Object)"node d");
        nodes.add((Object)d);
        Node e = new Node((Object)"node e");
        nodes.add((Object)e);
        Node f = new Node((Object)"node f");
        nodes.add((Object)f);
        edges.add((Object)new Edge(a, b));
        edges.add((Object)new Edge(a, c));
        edges.add((Object)new Edge(d, b));
        edges.add((Object)new Edge(a, f));
        edges.add((Object)new Edge(e, b));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph test3() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node a = new Node((Object)"node a");
        nodes.add((Object)a);
        Node b = new Node((Object)"node b");
        nodes.add((Object)b);
        Node c = new Node((Object)"node c");
        nodes.add((Object)c);
        Node d = new Node((Object)"node d");
        nodes.add((Object)d);
        a.width = 80;
        d.width = 75;
        edges.add((Object)new Edge(a, b));
        edges.add((Object)new Edge(a, c));
        edges.add((Object)new Edge(c, d));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph test4() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node a = new Node((Object)"node a");
        nodes.add((Object)a);
        Node b = new Node((Object)"node b");
        nodes.add((Object)b);
        Node c = new Node((Object)"node c");
        nodes.add((Object)c);
        Node d = new Node((Object)"node d");
        nodes.add((Object)d);
        Node e = new Node((Object)"node e");
        nodes.add((Object)e);
        Node f = new Node((Object)"node f");
        nodes.add((Object)f);
        Node g = new Node((Object)"node g");
        nodes.add((Object)g);
        Node h = new Node((Object)"node h");
        nodes.add((Object)h);
        Node i = new Node((Object)"node i");
        nodes.add((Object)i);
        Node j = new Node((Object)"node j");
        nodes.add((Object)j);
        Node k = new Node((Object)"node k");
        nodes.add((Object)k);
        edges.add((Object)new Edge(a, b));
        edges.add((Object)new Edge(a, c));
        edges.add((Object)new Edge(a, d));
        edges.add((Object)new Edge(b, e));
        edges.add((Object)new Edge(c, e));
        edges.add((Object)new Edge(d, e));
        edges.add((Object)new Edge(d, f));
        edges.add((Object)new Edge(d, g));
        edges.add((Object)new Edge(e, h));
        edges.add((Object)new Edge(f, h));
        edges.add((Object)new Edge(g, h));
        edges.add((Object)new Edge(g, i));
        edges.add((Object)new Edge(g, j));
        edges.add((Object)new Edge(h, k));
        edges.add((Object)new Edge(i, k));
        edges.add((Object)new Edge(j, k));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph tinyGraph() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node a = new Node((Object)"node a");
        nodes.add((Object)a);
        Node b = new Node((Object)"node b");
        nodes.add((Object)b);
        Node c = new Node((Object)"node c");
        nodes.add((Object)c);
        Node d = new Node((Object)"node d");
        nodes.add((Object)d);
        Node e = new Node((Object)"node e");
        nodes.add((Object)e);
        Node g = new Node((Object)"node g");
        nodes.add((Object)g);
        edges.add((Object)new Edge(a, d));
        edges.add((Object)new Edge(c, b));
        edges.add((Object)new Edge(b, g, 1, 3));
        edges.add((Object)new Edge(c, d));
        edges.add((Object)new Edge(d, e));
        edges.add((Object)new Edge(d, g));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    public static DirectedGraph unstableGraph() {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Node a0 = new Node((Object)"node a0");
        nodes.add((Object)a0);
        Node b0 = new Node((Object)"node b0");
        nodes.add((Object)b0);
        Node c0 = new Node((Object)"node c0");
        nodes.add((Object)c0);
        Node a1 = new Node((Object)"node a1");
        nodes.add((Object)a1);
        Node b1 = new Node((Object)"node b1");
        nodes.add((Object)b1);
        Node c1 = new Node((Object)"node c1");
        nodes.add((Object)c1);
        Node a2 = new Node((Object)"node a2");
        nodes.add((Object)a2);
        Node b2 = new Node((Object)"node b2");
        nodes.add((Object)b2);
        Node c2 = new Node((Object)"node c2");
        nodes.add((Object)c2);
        edges.add((Object)new Edge(a0, a1, 1, 9));
        edges.add((Object)new Edge(a1, a2, 1, 9));
        edges.add((Object)new Edge(b0, b1, 1, 9));
        edges.add((Object)new Edge(b1, b2, 1, 9));
        edges.add((Object)new Edge(c0, c1, 1, 9));
        edges.add((Object)new Edge(c1, c2, 1, 9));
        edges.add((Object)new Edge(a0, b2));
        edges.add((Object)new Edge(b0, c2));
        edges.add((Object)new Edge(c0, a2));
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }
}

