/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

class BufferedGraphicsSource
implements GraphicsSource {
    private GC imageGC;
    private GC controlGC;
    private Control control;
    private Rectangle inUse;

    public BufferedGraphicsSource(Control c) {
        this.control = c;
    }

    public void flushGraphics(Rectangle region) {
        if (this.inUse.isEmpty()) {
            return;
        }
        if (this.controlGC != null) {
            this.controlGC.dispose();
        }
        this.controlGC = null;
    }

    public Graphics getGraphics(Rectangle region) {
        if (this.control == null || this.control.isDisposed()) {
            return null;
        }
        Point ptSWT = this.control.getSize();
        this.inUse = new Rectangle(0, 0, ptSWT.x, ptSWT.y);
        this.inUse.intersect(region);
        if (this.inUse.isEmpty()) {
            return null;
        }
        this.controlGC = new GC((Drawable)this.control, this.control.getStyle() & 0x6000000);
        SWTGraphics graphics = new SWTGraphics(this.controlGC);
        ((Graphics)graphics).setClip(this.inUse);
        return graphics;
    }

    protected Image getImage() {
        return null;
    }

    protected GC getImageGC() {
        return this.imageGC;
    }
}

