/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.util;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.RuntimeProcess;

public class DebugUtil {
    public static String getLaunchName(ILaunch launch) {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        return launchConfiguration == null ? null : launchConfiguration.getName();
    }

    public static boolean containsCreateEventFor(DebugEvent[] events, ILaunch launch) {
        boolean result = false;
        int i = 0;
        while (!result && i < events.length) {
            DebugEvent event = events[i];
            result = DebugUtil.isCreateEvent(event) && DebugUtil.eventSourceEqualsLaunch(event, launch);
            ++i;
        }
        return result;
    }

    public static boolean containsTerminateEventFor(DebugEvent[] events, ILaunch launch) {
        boolean result = false;
        int i = 0;
        while (!result && i < events.length) {
            DebugEvent event = events[i];
            result = DebugUtil.isTerminateEvent(event) && DebugUtil.eventSourceEqualsLaunch(event, launch);
            ++i;
        }
        return result;
    }

    private static boolean eventSourceEqualsLaunch(DebugEvent debugEvent, ILaunch launch) {
        boolean result = false;
        if (debugEvent.getSource() instanceof RuntimeProcess) {
            RuntimeProcess runtimeProcess = (RuntimeProcess)debugEvent.getSource();
            result = runtimeProcess.getLaunch() == launch;
        }
        return result;
    }

    private static boolean isCreateEvent(DebugEvent event) {
        return event.getKind() == 4;
    }

    private static boolean isTerminateEvent(DebugEvent event) {
        return event.getKind() == 8;
    }

    private DebugUtil() {
    }
}

