/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.delegate;

import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.rap.ui.internal.launch.rwt.config.BrowserMode;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.util.DebugUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.statushandlers.StatusManager;

class BrowserOpener {
    private static final int CONNECT_TIMEOUT = 20000;
    private final ILaunch launch;
    private final RWTLaunchConfig launchConfig;
    private final URL url;

    BrowserOpener(ILaunch launch, String url) {
        this.launch = launch;
        this.launchConfig = new RWTLaunchConfig(launch.getLaunchConfiguration());
        this.url = BrowserOpener.toURL(url);
    }

    void scheduleOpen() {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (DebugUtil.containsCreateEventFor(events, BrowserOpener.this.launch)) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    BrowserOpener.this.scheduleOpenJob();
                } else if (DebugUtil.containsTerminateEventFor(events, BrowserOpener.this.launch)) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
        });
    }

    private void scheduleOpenJob() {
        Job job = new Job("Starting client application"){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Starting client application", -1);
                try {
                    BrowserOpener.this.waitForServletEngine(monitor);
                    BrowserOpener.this.open(monitor);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void open(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        String taskName = "Starting client application";
        subMonitor.beginTask(taskName, -1);
        try {
            this.openUrl();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            subMonitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        subMonitor.done();
    }

    private void openUrl() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (!BrowserOpener.this.launch.isTerminated()) {
                    try {
                        IWebBrowser browser = BrowserOpener.this.getBrowser();
                        browser.openURL(BrowserOpener.this.url);
                    }
                    catch (CoreException ce) {
                        BrowserOpener.handleCoreException(ce);
                    }
                }
            }
        });
    }

    IWebBrowser getBrowser() throws CoreException {
        int style = 14;
        style = BrowserMode.EXTERNAL.equals(this.launchConfig.getBrowserMode()) ? (style |= 0x80) : (style |= 0x20);
        String id = String.valueOf(this.launchConfig.getName()) + this.launchConfig.getBrowserMode();
        String name = this.launchConfig.getName();
        String toolTip = this.launchConfig.getName();
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        return support.createBrowser(style, id, name, toolTip);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForServletEngine(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        String taskName = "Waiting for servlet engine";
        subMonitor.beginTask(taskName, -1);
        try {
            long start = System.currentTimeMillis();
            boolean isReady = false;
            while (!(System.currentTimeMillis() - start > 20000L || isReady || Thread.interrupted() || monitor.isCanceled() || this.launch.isTerminated())) {
                isReady = this.canConnectToUrl();
                if (isReady) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            subMonitor.done();
            throw throwable;
        }
        {
            Object var7_8 = null;
        }
        subMonitor.done();
    }

    boolean canConnectToUrl() {
        boolean result = false;
        try {
            Socket socket = new Socket(this.url.getHost(), this.url.getPort());
            socket.close();
            result = true;
        }
        catch (Exception exception) {}
        return result;
    }

    private static void handleCoreException(CoreException coreException) {
        IStatus status = coreException.getStatus();
        StatusManager.getManager().handle(status, 2);
    }

    private static URL toURL(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            String msg = "Failed to create URL from string: " + urlString;
            throw new RuntimeException(msg, e);
        }
    }
}

