/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.service.IServiceHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ServiceHandlerRegistry {
    private static final String SERVICEHANDLER_XML = "servicehandler.xml";
    private final Map handlers = new HashMap();
    private boolean initialized;

    ServiceHandlerRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCustomHandler(String customHandlerId) {
        this.ensureInitialization();
        Map map = this.handlers;
        synchronized (map) {
            return this.handlers.containsKey(customHandlerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(String id, IServiceHandler handler) {
        this.ensureInitialization();
        Map map = this.handlers;
        synchronized (map) {
            this.handlers.put(id, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String id) {
        this.ensureInitialization();
        Map map = this.handlers;
        synchronized (map) {
            this.handlers.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IServiceHandler get(String customHandlerId) {
        this.ensureInitialization();
        Map map = this.handlers;
        synchronized (map) {
            return (IServiceHandler)this.handlers.get(customHandlerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialization() {
        Map map = this.handlers;
        synchronized (map) {
            if (!this.initialized) {
                this.registerHandlerInstances();
                this.initialized = true;
            }
        }
    }

    private void registerHandlerInstances() {
        try {
            IResourceManager resourceManager = RWT.getResourceManager();
            if (resourceManager != null) {
                this.registerHandlerInstances(resourceManager);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception exception) {
            String msg = "Could not load custom service handlers.";
            throw new RuntimeException(msg, exception);
        }
    }

    private void registerHandlerInstances(IResourceManager manager) throws Exception {
        Enumeration resources = manager.getResources(SERVICEHANDLER_XML);
        while (this.hasServiceHandlerDeclarations(resources)) {
            Document document = ServiceHandlerRegistry.parseDocument((URL)resources.nextElement());
            this.registerHandlerInstances(document);
        }
    }

    private boolean hasServiceHandlerDeclarations(Enumeration resources) {
        return resources != null && resources.hasMoreElements();
    }

    private static Document parseDocument(URL url) throws Exception, FactoryConfigurationError {
        DocumentBuilder builder = ServiceHandlerRegistry.createDocumentBuilder();
        URLConnection connection = ServiceHandlerRegistry.openConnection(url);
        return ServiceHandlerRegistry.parseDocument(builder, connection);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document parseDocument(DocumentBuilder builder, URLConnection connection) throws Exception {
        Document result;
        InputStream inputStream = connection.getInputStream();
        try {
            result = builder.parse(inputStream);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            inputStream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        inputStream.close();
        return result;
    }

    private static URLConnection openConnection(URL url) throws IOException {
        URLConnection result = url.openConnection();
        result.setUseCaches(false);
        return result;
    }

    private static DocumentBuilder createDocumentBuilder() throws FactoryConfigurationError, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return factory.newDocumentBuilder();
    }

    private void registerHandlerInstances(Document document) {
        NodeList handlerList = ServiceHandlerRegistry.getHandlerList(document);
        int i = 0;
        while (i < handlerList.getLength()) {
            String name = ServiceHandlerRegistry.getClassName(handlerList.item(i));
            String id = ServiceHandlerRegistry.getHandlerId(handlerList.item(i));
            this.registerHandlerInstance(id, name);
            ++i;
        }
    }

    private void registerHandlerInstance(String id, String name) {
        Object handlerInstance = ClassUtil.newInstance(this.getClass().getClassLoader(), name);
        this.handlers.put(id, handlerInstance);
    }

    private static NodeList getHandlerList(Document document) {
        return document.getElementsByTagName("handler");
    }

    private static String getHandlerId(Node item) {
        return ServiceHandlerRegistry.getAttribute(item, "requestparameter");
    }

    private static String getClassName(Node item) {
        return ServiceHandlerRegistry.getAttribute(item, "class");
    }

    private static String getAttribute(Node item, String attrName) {
        return item.getAttributes().getNamedItem(attrName).getNodeValue();
    }
}

