/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.engine;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.rwt.AdapterFactory;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.AdapterManager;
import org.eclipse.rwt.internal.EngineConfig;
import org.eclipse.rwt.internal.engine.ApplicationContext;
import org.eclipse.rwt.internal.engine.ApplicationContextUtil;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterFactory;
import org.eclipse.rwt.internal.lifecycle.PhaseListenerRegistry;
import org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler;
import org.eclipse.rwt.internal.resources.DefaultResourceManagerFactory;
import org.eclipse.rwt.internal.resources.JSLibraryServiceHandler;
import org.eclipse.rwt.internal.service.SettingStoreManager;
import org.eclipse.rwt.internal.textsize.MeasurementListener;
import org.eclipse.rwt.internal.theme.ResourceLoader;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rwt.internal.util.ClassInstantiationException;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.resources.IResource;
import org.eclipse.rwt.resources.IResourceManagerFactory;
import org.eclipse.rwt.service.ISettingStoreFactory;
import org.eclipse.rwt.service.RWTFileSettingStoreFactory;

public final class RWTServletContextListener
implements ServletContextListener {
    private static final String PREFIX = "org.eclipse.rwt.";
    public static final String ENTRY_POINTS_PARAM = "org.eclipse.rwt.entryPoints";
    public static final String THEMES_PARAM = "org.eclipse.rwt.themes";
    public static final String RESOURCE_MANAGER_FACTORY_PARAM = "org.eclipse.rwt.resourceManagerFactory";
    public static final String SETTING_STORE_FACTORY_PARAM = "org.eclipse.rwt.settingStoreFactory";
    public static final String ADAPTER_FACTORIES_PARAM = "org.eclipse.rwt.adapterFactories";
    public static final String PHASE_LISTENERS_PARAM = "org.eclipse.rwt.phaseListeners";
    public static final String RESOURCES_PARAM = "org.eclipse.rwt.resources";
    public static final String BRANDINGS_PARAM = "org.eclipse.rwt.brandings";
    private static final String SEPARATOR = ",";
    private static final String REGISTERED_ENTRY_POINTS;
    private static final String REGISTERED_PHASE_LISTENERS;
    private static final String REGISTERED_RESOURCES;
    private static final String REGISTERED_BRANDINGS;
    private static final ClassLoader CLASS_LOADER;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.engine.RWTServletContextListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REGISTERED_ENTRY_POINTS = String.valueOf(clazz.getName()) + "registeredEntryPoints";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rwt.internal.engine.RWTServletContextListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REGISTERED_PHASE_LISTENERS = String.valueOf(clazz2.getName()) + "registeredPhaseListeners";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.rwt.internal.engine.RWTServletContextListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REGISTERED_RESOURCES = String.valueOf(clazz3.getName()) + "registeredResources";
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.rwt.internal.engine.RWTServletContextListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REGISTERED_BRANDINGS = String.valueOf(clazz4.getName()) + "registeredBrandings";
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("org.eclipse.rwt.internal.engine.RWTServletContextListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_LOADER = clazz5.getClassLoader();
    }

    public void contextInitialized(ServletContextEvent evt) {
        ServletContext servletContext = evt.getServletContext();
        ApplicationContext applicationContext = this.registerDefaultApplicationContext(servletContext);
        ContextInitializer initializer = new ContextInitializer(servletContext);
        ApplicationContextUtil.runWithInstance(applicationContext, initializer);
    }

    public void contextDestroyed(ServletContextEvent evt) {
        ServletContext servletContext = evt.getServletContext();
        ApplicationContext applicationContext = ApplicationContextUtil.getApplicationContext(servletContext);
        ContextDestroyer destroyer = new ContextDestroyer(servletContext);
        ApplicationContextUtil.runWithInstance(applicationContext, destroyer);
        this.deregisterDefaultApplicationContext(servletContext);
    }

    private ApplicationContext registerDefaultApplicationContext(ServletContext servletContext) {
        return ApplicationContextUtil.registerDefaultApplicationContext(servletContext);
    }

    void deregisterDefaultApplicationContext(ServletContext servletContext) {
        ApplicationContextUtil.deregisterApplicationContext(servletContext);
    }

    public static void registerEngineConfig(ServletContext servletContext) {
        String realPath = servletContext.getRealPath("/");
        EngineConfig engineConfig = new EngineConfig(realPath);
        RWTFactory.getConfigurationReader().setEngineConfig(engineConfig);
    }

    public static void registerEntryPoints(ServletContext context) {
        HashSet<String> registeredEntryPoints = new HashSet<String>();
        String value = context.getInitParameter(ENTRY_POINTS_PARAM);
        if (value != null) {
            String[] entryPoints = value.split(SEPARATOR);
            int i = 0;
            while (i < entryPoints.length) {
                String entryPoint = entryPoints[i];
                String[] parts = entryPoint.trim().split("#");
                String className = parts[0];
                String entryPointName = "default";
                if (parts.length > 1) {
                    entryPointName = parts[1];
                }
                try {
                    Class<?> clazz = Class.forName(className);
                    RWTFactory.getEntryPointManager().register(entryPointName, clazz);
                    registeredEntryPoints.add(entryPointName);
                }
                catch (Exception ex) {
                    String text = "Failed to register entry point ''{0}''.";
                    Object[] args = new Object[]{entryPoint};
                    String msg = MessageFormat.format(text, args);
                    context.log(msg, (Throwable)ex);
                }
                ++i;
            }
        }
        RWTServletContextListener.setRegisteredEntryPoints(context, registeredEntryPoints);
    }

    public static void deregisterEntryPoints(ServletContext context) {
        String[] entryPoints = RWTServletContextListener.getRegisteredEntryPoints(context);
        if (entryPoints != null) {
            int i = 0;
            while (i < entryPoints.length) {
                RWTFactory.getEntryPointManager().deregister(entryPoints[i]);
                ++i;
            }
        }
    }

    public static void setRegisteredEntryPoints(ServletContext context, Set entryPoints) {
        String[] value = new String[entryPoints.size()];
        entryPoints.toArray(value);
        context.setAttribute(REGISTERED_ENTRY_POINTS, (Object)value);
    }

    public static String[] getRegisteredEntryPoints(ServletContext context) {
        return (String[])context.getAttribute(REGISTERED_ENTRY_POINTS);
    }

    public static void registerResourceManagerFactory(ServletContext context) {
        String factoryName = context.getInitParameter(RESOURCE_MANAGER_FACTORY_PARAM);
        if (factoryName != null) {
            try {
                IResourceManagerFactory factory = (IResourceManagerFactory)ClassUtil.newInstance(CLASS_LOADER, factoryName);
                RWTFactory.getResourceManagerProvider().registerFactory(factory);
            }
            catch (ClassInstantiationException ex) {
                String text = "Failed to register resource manager factory ''{0}''.";
                String msg = MessageFormat.format(text, factoryName);
                context.log(msg, (Throwable)ex);
            }
        } else {
            RWTFactory.getResourceManagerProvider().registerFactory(new DefaultResourceManagerFactory());
        }
    }

    public static void registerSettingStoreFactory(ServletContext context) {
        SettingStoreManager settingStoreManager = RWTFactory.getSettingStoreManager();
        if (!settingStoreManager.hasFactory()) {
            String factoryName = context.getInitParameter(SETTING_STORE_FACTORY_PARAM);
            if (factoryName != null) {
                try {
                    ISettingStoreFactory factory = (ISettingStoreFactory)ClassUtil.newInstance(CLASS_LOADER, factoryName);
                    settingStoreManager.register(factory);
                }
                catch (ClassInstantiationException cie) {
                    String message = "Failed to register setting store factory: " + factoryName;
                    context.log(message, (Throwable)cie);
                }
            } else {
                settingStoreManager.register(new RWTFileSettingStoreFactory());
            }
        }
    }

    public static void registerAdapterFactories(ServletContext context) {
        String initParam = context.getInitParameter(ADAPTER_FACTORIES_PARAM);
        AdapterManager adapterManager = RWTFactory.getAdapterManager();
        if (initParam != null) {
            String[] factoryParams = initParam.split(SEPARATOR);
            int i = 0;
            while (i < factoryParams.length) {
                String[] classNames = factoryParams[i].trim().split("#");
                if (classNames.length != 2) {
                    Object[] param = new Object[]{factoryParams[i]};
                    String text = "''{0}'' is not a valid factory-adaptable pair.";
                    String msg = MessageFormat.format(text, param);
                    context.log(msg);
                } else {
                    try {
                        Class<?> factoryClass = Class.forName(classNames[0]);
                        Class<?> adaptableClass = Class.forName(classNames[1]);
                        AdapterFactory factory = (AdapterFactory)ClassUtil.newInstance(factoryClass);
                        adapterManager.registerAdapters(adaptableClass, factory);
                    }
                    catch (Throwable thr) {
                        Object[] param = new Object[]{factoryParams[i]};
                        String text = "Could not register the factory-adaptable ''{0}'' pair.";
                        String msg = MessageFormat.format(text, param);
                        context.log(msg, thr);
                    }
                }
                ++i;
            }
        } else {
            LifeCycleAdapterFactory lifeCycleAdapterFactory = new LifeCycleAdapterFactory();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.widgets.Widget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapterManager.registerAdapters(clazz, lifeCycleAdapterFactory);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.swt.widgets.Display");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapterManager.registerAdapters(clazz2, lifeCycleAdapterFactory);
        }
    }

    public static void registerPhaseListener(ServletContext context) {
        ArrayList<PhaseListener> phaseListeners = new ArrayList<PhaseListener>();
        String initParam = context.getInitParameter(PHASE_LISTENERS_PARAM);
        if (initParam != null) {
            String[] listenerNames = initParam.split(SEPARATOR);
            int i = 0;
            while (i < listenerNames.length) {
                String className = listenerNames[i].trim();
                try {
                    PhaseListener lsnr = (PhaseListener)ClassUtil.newInstance(CLASS_LOADER, className);
                    phaseListeners.add(lsnr);
                }
                catch (ClassInstantiationException cie) {
                    String text = "Failed to register phase listener ''{0}''.";
                    String msg = MessageFormat.format(text, className);
                    context.log(msg, (Throwable)cie);
                }
                ++i;
            }
        } else {
            phaseListeners.add(new CurrentPhase.Listener());
            phaseListeners.add(new MeasurementListener());
        }
        PhaseListenerRegistry phaseListenerRegistry = RWTFactory.getPhaseListenerRegistry();
        PhaseListener[] registeredListeners = new PhaseListener[phaseListeners.size()];
        phaseListeners.toArray(registeredListeners);
        int i = 0;
        while (i < registeredListeners.length) {
            phaseListenerRegistry.add(registeredListeners[i]);
            ++i;
        }
        context.setAttribute(REGISTERED_PHASE_LISTENERS, (Object)registeredListeners);
    }

    public static void deregisterPhaseListeners(ServletContext context) {
        PhaseListenerRegistry phaseListenerRegistry = RWTFactory.getPhaseListenerRegistry();
        PhaseListener[] listeners = RWTServletContextListener.getRegisteredPhaseListeners(context);
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                phaseListenerRegistry.remove(listeners[i]);
                ++i;
            }
        }
    }

    private static PhaseListener[] getRegisteredPhaseListeners(ServletContext context) {
        return (PhaseListener[])context.getAttribute(REGISTERED_PHASE_LISTENERS);
    }

    public static void registerResources(ServletContext context) {
        int i;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        String initParam = context.getInitParameter(RESOURCES_PARAM);
        if (initParam != null) {
            String[] resourceClassNames = initParam.split(SEPARATOR);
            i = 0;
            while (i < resourceClassNames.length) {
                String className = resourceClassNames[i].trim();
                try {
                    IResource resource = (IResource)ClassUtil.newInstance(CLASS_LOADER, className);
                    resources.add(resource);
                }
                catch (ClassInstantiationException cie) {
                    String text = "Failed to register resource ''{0}''.";
                    String msg = MessageFormat.format(text, className);
                    context.log(msg, (Throwable)cie);
                }
                ++i;
            }
        }
        IResource[] registeredResources = new IResource[resources.size()];
        resources.toArray(registeredResources);
        i = 0;
        while (i < registeredResources.length) {
            RWTFactory.getResourceRegistry().add(registeredResources[i]);
            ++i;
        }
        context.setAttribute(REGISTERED_RESOURCES, (Object)registeredResources);
    }

    public static void deregisterResources(ServletContext context) {
        RWTFactory.getResourceRegistry().clear();
    }

    public static void registerThemes(ServletContext context) {
        ThemeManager manager = ThemeManager.getInstance();
        String value = context.getInitParameter(THEMES_PARAM);
        ResourceLoader loader = new ResourceLoader(){

            public InputStream getResourceAsStream(String resourceName) throws IOException {
                return this.getClass().getClassLoader().getResourceAsStream(resourceName);
            }
        };
        if (value != null) {
            String[] themes = value.split(SEPARATOR);
            int i = 0;
            while (i < themes.length) {
                String[] parts = themes[i].trim().split("#");
                if (parts.length >= 2) {
                    String themeId = parts[0];
                    String fileName = parts[1];
                    try {
                        String themeName = "Unnamed Theme: " + themeId;
                        StyleSheet styleSheet = CssFileReader.readStyleSheet(fileName, loader);
                        Theme theme = new Theme(themeId, themeName, styleSheet);
                        manager.registerTheme(theme);
                    }
                    catch (Exception e) {
                        String text = "Failed to register custom theme ''{0}'' from resource ''{1}''";
                        Object[] args = new Object[]{themeId, fileName};
                        String msg = MessageFormat.format(text, args);
                        context.log(msg, (Throwable)e);
                    }
                }
                ++i;
            }
        }
        manager.initialize();
    }

    public static void deregisterThemes(ServletContext context) {
        ThemeManager.resetInstance();
    }

    public static void registerUICallBackServiceHandler() {
        RWTFactory.getServiceManager().registerServiceHandler(UICallBackServiceHandler.HANDLER_ID, new UICallBackServiceHandler());
    }

    public static void deregisterUICallBackServiceHandler() {
        RWTFactory.getServiceManager().unregisterServiceHandler(UICallBackServiceHandler.HANDLER_ID);
    }

    public static void registerBrandings(ServletContext context) {
        String value = context.getInitParameter(BRANDINGS_PARAM);
        if (value != null) {
            ArrayList<AbstractBranding> registeredBrandings = new ArrayList<AbstractBranding>();
            String[] brandings = value.split(SEPARATOR);
            int i = 0;
            while (i < brandings.length) {
                String className = brandings[i].trim();
                try {
                    AbstractBranding branding = (AbstractBranding)ClassUtil.newInstance(CLASS_LOADER, className);
                    RWTFactory.getBrandingManager().register(branding);
                    registeredBrandings.add(branding);
                }
                catch (ClassInstantiationException cie) {
                    String text = "Failed to register branding ''{0}''.";
                    String msg = MessageFormat.format(text, className);
                    context.log(msg, (Throwable)cie);
                }
                ++i;
            }
            RWTServletContextListener.setRegisteredBrandings(context, registeredBrandings);
        }
    }

    public static void setRegisteredBrandings(ServletContext context, List brandings) {
        AbstractBranding[] registeredBrandings = new AbstractBranding[brandings.size()];
        brandings.toArray(registeredBrandings);
        context.setAttribute(REGISTERED_BRANDINGS, (Object)registeredBrandings);
    }

    public static void deregisterBrandings(ServletContext context) {
        AbstractBranding[] brandings = (AbstractBranding[])context.getAttribute(REGISTERED_BRANDINGS);
        if (brandings != null) {
            int i = 0;
            while (i < brandings.length) {
                RWTFactory.getBrandingManager().deregister(brandings[i]);
                ++i;
            }
        }
    }

    public static void registerJSLibraryServiceHandler() {
        RWTFactory.getServiceManager().registerServiceHandler(JSLibraryServiceHandler.HANDLER_ID, new JSLibraryServiceHandler());
        RWTFactory.getJSLibraryConcatenator().startJSConcatenation();
    }

    public static void deregisterJSLibraryServiceHandler() {
        RWTFactory.getServiceManager().unregisterServiceHandler(JSLibraryServiceHandler.HANDLER_ID);
    }

    public static class ContextDestroyer
    implements Runnable {
        private final ServletContext servletContext;

        public ContextDestroyer(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public void run() {
            RWTServletContextListener.deregisterBrandings(this.servletContext);
            RWTServletContextListener.deregisterEntryPoints(this.servletContext);
            RWTServletContextListener.deregisterPhaseListeners(this.servletContext);
            RWTServletContextListener.deregisterResources(this.servletContext);
            RWTServletContextListener.deregisterUICallBackServiceHandler();
            RWTServletContextListener.deregisterJSLibraryServiceHandler();
            RWTFactory.getLifeCycleFactory().destroy();
        }
    }

    public static class ContextInitializer
    implements Runnable {
        protected final ServletContext servletContext;

        public ContextInitializer(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public void run() {
            RWTServletContextListener.registerEngineConfig(this.servletContext);
            RWTServletContextListener.registerResourceManagerFactory(this.servletContext);
            RWTServletContextListener.registerThemes(this.servletContext);
            RWTServletContextListener.registerBrandings(this.servletContext);
            RWTServletContextListener.registerEntryPoints(this.servletContext);
            RWTServletContextListener.registerSettingStoreFactory(this.servletContext);
            RWTServletContextListener.registerAdapterFactories(this.servletContext);
            RWTServletContextListener.registerPhaseListener(this.servletContext);
            RWTServletContextListener.registerResources(this.servletContext);
            RWTServletContextListener.registerUICallBackServiceHandler();
            RWTServletContextListener.registerJSLibraryServiceHandler();
        }
    }
}

