/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rwt.internal.lifecycle.JavaScriptResponseWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public final class ActiveKeysUtil {
    private static final String JSFUNC_SET_ACTIVE_KEYS = "org.eclipse.rwt.KeyEventUtil.getInstance().setKeyBindings";
    private static final Map KEY_MAP = new HashMap();
    private static final String ALT = "ALT+";
    private static final String CTRL = "CTRL+";
    private static final String SHIFT = "SHIFT+";
    static final String PROP_ACTIVE_KEYS = "activeKeys";
    static /* synthetic */ Class class$0;

    static {
        KEY_MAP.put("BACKSPACE", new Integer(8));
        KEY_MAP.put("BS", new Integer(8));
        KEY_MAP.put("TAB", new Integer(9));
        KEY_MAP.put("RETURN", new Integer(13));
        KEY_MAP.put("ENTER", new Integer(13));
        KEY_MAP.put("CR", new Integer(13));
        KEY_MAP.put("PAUSE", new Integer(19));
        KEY_MAP.put("BREAK", new Integer(19));
        KEY_MAP.put("CAPS_LOCK", new Integer(20));
        KEY_MAP.put("ESCAPE", new Integer(27));
        KEY_MAP.put("ESC", new Integer(27));
        KEY_MAP.put("SPACE", new Integer(32));
        KEY_MAP.put("PAGE_UP", new Integer(33));
        KEY_MAP.put("PAGE_DOWN", new Integer(34));
        KEY_MAP.put("END", new Integer(35));
        KEY_MAP.put("HOME", new Integer(36));
        KEY_MAP.put("ARROW_LEFT", new Integer(37));
        KEY_MAP.put("ARROW_UP", new Integer(38));
        KEY_MAP.put("ARROW_RIGHT", new Integer(39));
        KEY_MAP.put("ARROW_DOWN", new Integer(40));
        KEY_MAP.put("PRINT_SCREEN", new Integer(44));
        KEY_MAP.put("INSERT", new Integer(45));
        KEY_MAP.put("DEL", new Integer(46));
        KEY_MAP.put("DELETE", new Integer(46));
        KEY_MAP.put("F1", new Integer(112));
        KEY_MAP.put("F2", new Integer(113));
        KEY_MAP.put("F3", new Integer(114));
        KEY_MAP.put("F4", new Integer(115));
        KEY_MAP.put("F5", new Integer(116));
        KEY_MAP.put("F6", new Integer(117));
        KEY_MAP.put("F7", new Integer(118));
        KEY_MAP.put("F8", new Integer(119));
        KEY_MAP.put("F9", new Integer(120));
        KEY_MAP.put("F10", new Integer(121));
        KEY_MAP.put("F11", new Integer(122));
        KEY_MAP.put("F12", new Integer(123));
        KEY_MAP.put("NUMPAD_0", new Integer(96));
        KEY_MAP.put("NUMPAD_1", new Integer(97));
        KEY_MAP.put("NUMPAD_2", new Integer(98));
        KEY_MAP.put("NUMPAD_3", new Integer(99));
        KEY_MAP.put("NUMPAD_4", new Integer(100));
        KEY_MAP.put("NUMPAD_5", new Integer(101));
        KEY_MAP.put("NUMPAD_6", new Integer(102));
        KEY_MAP.put("NUMPAD_7", new Integer(103));
        KEY_MAP.put("NUMPAD_8", new Integer(104));
        KEY_MAP.put("NUMPAD_9", new Integer(105));
        KEY_MAP.put("NUMPAD_MULTIPLY", new Integer(106));
        KEY_MAP.put("NUMPAD_ADD", new Integer(107));
        KEY_MAP.put("NUMPAD_SUBTRACT", new Integer(109));
        KEY_MAP.put("NUMPAD_DECIMAL", new Integer(110));
        KEY_MAP.put("NUMPAD_DIVIDE", new Integer(111));
        KEY_MAP.put("NUM_LOCK", new Integer(144));
        KEY_MAP.put("SCROLL_LOCK", new Integer(145));
        KEY_MAP.put(",", new Integer(188));
        KEY_MAP.put(".", new Integer(190));
        KEY_MAP.put("/", new Integer(191));
        KEY_MAP.put("`", new Integer(192));
        KEY_MAP.put("[", new Integer(219));
        KEY_MAP.put("\\", new Integer(220));
        KEY_MAP.put("]", new Integer(221));
        KEY_MAP.put("'", new Integer(222));
    }

    private ActiveKeysUtil() {
    }

    static void preserveActiveKeys(Display display) {
        IWidgetAdapter adapter = DisplayUtil.getAdapter((Display)display);
        adapter.preserve(PROP_ACTIVE_KEYS, (Object)ActiveKeysUtil.getActiveKeys(display));
    }

    static void readKeyEvents(final Display display) {
        if (ActiveKeysUtil.wasEventSent("org.eclipse.swt.events.keyDown")) {
            final int keyCode = ActiveKeysUtil.readIntParam("org.eclipse.swt.events.keyDown.keyCode");
            final int charCode = ActiveKeysUtil.readIntParam("org.eclipse.swt.events.keyDown.charCode");
            final int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.keyDown.modifier");
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    Event event = ActiveKeysUtil.createEvent(display, keyCode, charCode, stateMask);
                    ActiveKeysUtil.processEvent(display, event);
                }
            });
        }
    }

    static void writeActiveKeys(Display display) {
        if (!display.isDisposed()) {
            boolean hasChanged;
            IWidgetAdapter adapter = DisplayUtil.getAdapter((Display)display);
            Object[] newValue = ActiveKeysUtil.getActiveKeys(display);
            Object[] oldValue = (String[])adapter.getPreserved(PROP_ACTIVE_KEYS);
            boolean bl = hasChanged = !Arrays.equals(oldValue, newValue);
            if (hasChanged) {
                ActiveKeysUtil.writeActiveKeys((String[])newValue);
            }
        }
    }

    private static void writeActiveKeys(String[] newValue) {
        StringBuffer jsCode = new StringBuffer();
        jsCode.append(JSFUNC_SET_ACTIVE_KEYS);
        jsCode.append("(");
        jsCode.append(ActiveKeysUtil.toJson(newValue));
        jsCode.append(");");
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        JavaScriptResponseWriter responseWriter = stateInfo.getResponseWriter();
        responseWriter.write(jsCode.toString());
    }

    private static String[] getActiveKeys(Display display) {
        String[] result = null;
        Object data = display.getData("org.eclipse.rap.rwt.activeKeys");
        if (data != null) {
            if (data instanceof String[]) {
                String[] activeKeys = (String[])data;
                result = new String[activeKeys.length];
                System.arraycopy(activeKeys, 0, result, 0, activeKeys.length);
            } else {
                String mesg = "Illegal value for RWT.ACTIVE_KEYS in display data, must be a string array";
                throw new IllegalArgumentException(mesg);
            }
        }
        return result;
    }

    private static String toJson(String[] activeKeys) {
        StringBuffer json = new StringBuffer();
        json.append("{");
        if (activeKeys != null) {
            int i = 0;
            while (i < activeKeys.length) {
                json.append("\"");
                json.append(ActiveKeysUtil.translateKeySequence(activeKeys[i]));
                json.append("\":true");
                if (i < activeKeys.length - 1) {
                    json.append(",");
                }
                ++i;
            }
        }
        json.append("}");
        return json.toString();
    }

    private static String translateKeySequence(String keySequence) {
        if (keySequence == null) {
            throw new NullPointerException("Null argument");
        }
        if (keySequence.trim().length() == 0) {
            throw new IllegalArgumentException("Empty key sequence definition found");
        }
        int lastPlusIndex = keySequence.lastIndexOf("+");
        String modifierPart = "";
        String keyPart = "";
        if (lastPlusIndex != -1) {
            modifierPart = keySequence.substring(0, lastPlusIndex + 1);
            keyPart = keySequence.substring(lastPlusIndex + 1);
        } else {
            keyPart = keySequence;
        }
        return String.valueOf(ActiveKeysUtil.getModifierKeys(modifierPart)) + ActiveKeysUtil.getKeyCode(keyPart);
    }

    private static String getModifierKeys(String modifier) {
        StringBuffer result = new StringBuffer();
        if (modifier.indexOf(ALT) != -1) {
            result.append(ALT);
        }
        if (modifier.indexOf(CTRL) != -1) {
            result.append(CTRL);
        }
        if (modifier.indexOf(SHIFT) != -1) {
            result.append(SHIFT);
        }
        if (modifier.length() != result.length()) {
            throw new IllegalArgumentException("Unrecognized modifier found in key sequence: " + modifier);
        }
        return result.toString();
    }

    private static int getKeyCode(String key) {
        int result = -1;
        Object value = KEY_MAP.get(key);
        if (value instanceof Integer) {
            result = (Integer)value;
        } else if (key.length() == 1) {
            result = key.charAt(0);
        } else {
            throw new IllegalArgumentException("Unrecognized key: " + key);
        }
        return result;
    }

    private static Event createEvent(Display display, int keyCode, int charCode, int stateMask) {
        Event event = new Event();
        event.display = display;
        event.type = 1;
        if (charCode == 0) {
            event.keyCode = ActiveKeysUtil.translateKeyCode(keyCode);
            if ((event.keyCode & 0x1000000) == 0) {
                event.character = ActiveKeysUtil.translateCharacter(event.keyCode);
            }
        } else {
            event.keyCode = charCode;
            event.character = ActiveKeysUtil.translateCharacter(charCode);
        }
        event.stateMask = stateMask;
        return event;
    }

    private static void processEvent(Display display, Event event) {
        IDisplayAdapter.IFilterEntry[] filters = ActiveKeysUtil.getFilterEntries(display);
        int i = 0;
        while (i < filters.length) {
            if (filters[i].getType() == event.type) {
                filters[i].getListener().handleEvent(event);
            }
            ++i;
        }
    }

    private static IDisplayAdapter.IFilterEntry[] getFilterEntries(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDisplayAdapter adapter = (IDisplayAdapter)display.getAdapter((Class)clazz);
        return adapter.getFilters();
    }

    private static boolean wasEventSent(String eventName) {
        HttpServletRequest request = ContextProvider.getRequest();
        String widgetId = request.getParameter(eventName);
        return "w1".equals(widgetId);
    }

    private static int readIntParam(String paramName) {
        String value = ActiveKeysUtil.readStringParam(paramName);
        return NumberFormatUtil.parseInt((String)value);
    }

    private static String readStringParam(String paramName) {
        HttpServletRequest request = ContextProvider.getRequest();
        return request.getParameter(paramName);
    }

    private static int translateKeyCode(int keyCode) {
        int result;
        switch (keyCode) {
            case 20: {
                result = 16777298;
                break;
            }
            case 38: {
                result = 0x1000001;
                break;
            }
            case 37: {
                result = 0x1000003;
                break;
            }
            case 39: {
                result = 0x1000004;
                break;
            }
            case 40: {
                result = 0x1000002;
                break;
            }
            case 33: {
                result = 0x1000005;
                break;
            }
            case 34: {
                result = 0x1000006;
                break;
            }
            case 35: {
                result = 0x1000008;
                break;
            }
            case 36: {
                result = 0x1000007;
                break;
            }
            case 45: {
                result = 0x1000009;
                break;
            }
            case 46: {
                result = 127;
                break;
            }
            case 112: {
                result = 0x100000A;
                break;
            }
            case 113: {
                result = 0x100000B;
                break;
            }
            case 114: {
                result = 0x100000C;
                break;
            }
            case 115: {
                result = 0x100000D;
                break;
            }
            case 116: {
                result = 0x100000E;
                break;
            }
            case 117: {
                result = 0x100000F;
                break;
            }
            case 118: {
                result = 0x1000010;
                break;
            }
            case 119: {
                result = 0x1000011;
                break;
            }
            case 120: {
                result = 0x1000012;
                break;
            }
            case 121: {
                result = 0x1000013;
                break;
            }
            case 122: {
                result = 0x1000014;
                break;
            }
            case 123: {
                result = 0x1000015;
                break;
            }
            case 144: {
                result = 16777299;
                break;
            }
            case 44: {
                result = 16777303;
                break;
            }
            case 145: {
                result = 16777300;
                break;
            }
            case 19: {
                result = 0x1000055;
                break;
            }
            case 96: {
                result = 0x1000030;
                break;
            }
            case 97: {
                result = 0x1000031;
                break;
            }
            case 98: {
                result = 16777266;
                break;
            }
            case 99: {
                result = 0x1000033;
                break;
            }
            case 100: {
                result = 16777268;
                break;
            }
            case 101: {
                result = 16777269;
                break;
            }
            case 102: {
                result = 16777270;
                break;
            }
            case 103: {
                result = 16777271;
                break;
            }
            case 104: {
                result = 16777272;
                break;
            }
            case 105: {
                result = 16777273;
                break;
            }
            case 106: {
                result = 16777258;
                break;
            }
            case 107: {
                result = 16777259;
                break;
            }
            case 109: {
                result = 16777261;
                break;
            }
            case 110: {
                result = 16777262;
                break;
            }
            case 111: {
                result = 16777263;
                break;
            }
            case 188: {
                result = 44;
                break;
            }
            case 190: {
                result = 46;
                break;
            }
            case 191: {
                result = 47;
                break;
            }
            case 192: {
                result = 96;
                break;
            }
            case 219: {
                result = 91;
                break;
            }
            case 220: {
                result = 92;
                break;
            }
            case 221: {
                result = 93;
                break;
            }
            case 222: {
                result = 39;
                break;
            }
            default: {
                result = keyCode;
            }
        }
        return result;
    }

    private static char translateCharacter(int keyCode) {
        char result = '\u0000';
        if (Character.isDefined((char)keyCode)) {
            result = (char)keyCode;
        }
        return result;
    }
}

