/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.DataStorage;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.logging.LoggingLocalization;
import org.eclipse.persistence.jpa.rs.util.MethodExitLogData;

public class JPARSLogger {
    static final Logger logger = Logger.getLogger("org.eclipse.persistence.jpars");

    public static void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (logger.isLoggable(Level.FINEST)) {
            try {
                logger.entering(sourceClass, sourceMethod, JPARSLogger.getParamsWithAdditionalInfo(params));
            }
            catch (Throwable throwable) {}
        }
    }

    public static void entering(String sourceClass, String sourceMethod, InputStream in) {
        if (logger.isLoggable(Level.FINEST) && in.markSupported()) {
            try {
                String data = JPARSLogger.readData(in);
                in.reset();
                if (data != null) {
                    logger.entering(sourceClass, sourceMethod, JPARSLogger.getParamsWithAdditionalInfo(new Object[]{data}));
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static void exiting(String sourceClass, String sourceMethod, Object[] params) {
        if (logger.isLoggable(Level.FINEST)) {
            try {
                logger.exiting(sourceClass, sourceMethod, new MethodExitLogData(JPARSLogger.getParamsWithAdditionalInfo(params)));
            }
            catch (Throwable throwable) {}
        }
    }

    public static void exiting(String sourceClass, String sourceMethod, PersistenceContext context, Object object, MediaType mediaType) {
        if (logger.isLoggable(Level.FINEST) && context != null && object != null && mediaType != null) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                context.marshall(object, mediaType, outputStream, true);
                if (object instanceof PersistenceWeavedRest) {
                    JPARSLogger.exiting(sourceClass, sourceMethod, new Object[]{object.getClass().getName(), outputStream.toString("UTF-8")});
                } else {
                    JPARSLogger.exiting(sourceClass, sourceMethod, new Object[]{outputStream.toString("UTF-8")});
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static void finest(String message, Object[] params) {
        JPARSLogger.log(message, Level.FINEST, JPARSLogger.getParamsWithAdditionalInfo(params));
    }

    public static void fine(String message, Object[] params) {
        JPARSLogger.log(message, Level.FINE, JPARSLogger.getParamsWithAdditionalInfo(params));
    }

    public static void warning(String message, Object[] params) {
        JPARSLogger.log(message, Level.WARNING, JPARSLogger.getParamsWithAdditionalInfo(params));
    }

    public static void error(String message, Object[] params) {
        JPARSLogger.log(message, Level.SEVERE, JPARSLogger.getParamsWithAdditionalInfo(params));
    }

    public static void exception(String message, Object[] params, Exception exc) {
        logger.log(Level.SEVERE, LoggingLocalization.buildMessage(message, JPARSLogger.getParamsWithAdditionalInfo(params)), exc);
    }

    public static void setLogLevel(Level level) {
        logger.setLevel(level);
    }

    public static boolean isLoggableFinest() {
        return logger.isLoggable(Level.FINEST);
    }

    private static Object[] getParamsWithAdditionalInfo(Object[] params) {
        String requestId = (String)DataStorage.get("requestId");
        if (params != null) {
            Object[] paramsWithRequestId = new Object[params.length + 1];
            paramsWithRequestId[0] = requestId;
            System.arraycopy(params, 0, paramsWithRequestId, 1, params.length);
            return paramsWithRequestId;
        }
        return new Object[]{requestId};
    }

    private static void log(String message, Level level, Object[] params) {
        logger.log(level, LoggingLocalization.buildMessage(message, params));
    }

    private static String readData(InputStream is) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ByteArrayInputStream bais = null;
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] bytes = buffer.toByteArray();
            bais = new ByteArrayInputStream(bytes);
        }
        catch (IOException iOException) {}
        return JPARSLogger.getDataFromInputStream(bais);
    }

    private static String getDataFromInputStream(InputStream is) {
        StringBuilder sb;
        block18: {
            BufferedReader br = null;
            sb = new StringBuilder();
            try {
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(is));
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (br != null) {
                            br.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        break block18;
                    }
                    catch (Exception exception) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }
}

