/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCursorType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.UnresolvedTypesVisitor;
import org.eclipse.persistence.tools.oracleddl.test.AllTests;
import org.eclipse.persistence.tools.oracleddl.test.TestHelper;
import org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder.DatabaseTypeBuilderTestSuite;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AnchoredTypesResolutionTestSuite {
    static final String CREATE_TABLE_PREFIX = "CREATE TABLE ";
    static final String CREATE_PACKAGE_PREFIX = "CREATE PACKAGE ";
    static final String ANCHORED_TYPES_TEST4_PACKAGE = "ANCHORED_TYPES_TEST4";
    static final String ANCHORED_TYPES_TABLE2 = "ANCHORED_TYPES_TABLE2";
    static final String CREATE_ANCHORED_TYPES_TABLE2 = "CREATE TABLE ANCHORED_TYPES_TABLE2 (\nID NUMBER NOT NULL,\nNAME VARCHAR2(80),\nSINCE DATE,\nPRIMARY KEY (ID)\n)";
    static final String ANCHORED_TYPES_TABLE_FIELD = "NAME";
    static final String ANCHORED_TYPE1_NAME = "WNAME";
    static final String ANCHORED_TYPE1 = "ANCHORED_TYPES_TABLE2.NAME%TYPE";
    static final String ANCHORED_TYPE2_NAME = "ANCHORED_TYPE2";
    static final String ANCHORED_TYPE2 = "ANCHORED_TYPES_TABLE2%ROWTYPE";
    static final String ANCHORED_TYPE3_NAME = "ANCHORED_CURSOR";
    static final String CREATE_ANCHORED_TYPES_TEST1_PACKAGE = "CREATE PACKAGE ANCHORED_TYPES_TEST4 AS\nSUBTYPE WNAME IS ANCHORED_TYPES_TABLE2.NAME%TYPE;\nSUBTYPE ANCHORED_TYPE2 IS ANCHORED_TYPES_TABLE2%ROWTYPE;\nTYPE ANCHORED_CURSOR IS REF CURSOR RETURN ANCHORED_TYPE2;\nARECORD_VAR ANCHORED_TYPE2;\nSUBTYPE WNAME2 IS ARECORD_VAR.NAME%TYPE;\nTYPE ANCHORED_CURSOR2 IS REF CURSOR RETURN ARECORD_VAR%TYPE;\nEND ANCHORED_TYPES_TEST4;";
    static final String DROP_ANCHORED_TYPES_TABLE2 = "DROP TABLE ANCHORED_TYPES_TABLE2";
    static final String DROP_ANCHORED_TYPES_TEST1_PACKAGE = "DROP PACKAGE ANCHORED_TYPES_TEST4";
    static DatabaseTypeBuilder dtBuilder = DatabaseTypeBuilderTestSuite.dtBuilder;
    static Connection conn = AllTests.conn;
    static List<String> expectedFieldNames = new ArrayList<String>();
    static List<String> expectedPKFieldNames = new ArrayList<String>();
    static boolean ddlCreate = false;
    static boolean ddlDrop = false;
    static boolean ddlDebug = false;

    @BeforeClass
    public static void setUp() throws ClassNotFoundException, SQLException {
        String ddlDebugProp;
        String ddlDropProp;
        conn = TestHelper.buildConnection();
        dtBuilder = new DatabaseTypeBuilder();
        String ddlCreateProp = System.getProperty("db.ddl.create", "false");
        if ("true".equalsIgnoreCase(ddlCreateProp)) {
            ddlCreate = true;
        }
        if ("true".equalsIgnoreCase(ddlDropProp = System.getProperty("db.ddl.drop", "false"))) {
            ddlDrop = true;
        }
        if ("true".equalsIgnoreCase(ddlDebugProp = System.getProperty("db.ddl.debug", "false"))) {
            ddlDebug = true;
        }
        if (ddlCreate) {
            TestHelper.runDdl(conn, CREATE_ANCHORED_TYPES_TABLE2, ddlDebug);
            TestHelper.runDdl(conn, CREATE_ANCHORED_TYPES_TEST1_PACKAGE, ddlDebug);
        }
    }

    @AfterClass
    public static void tearDown() {
        if (ddlDrop) {
            TestHelper.runDdl(conn, DROP_ANCHORED_TYPES_TABLE2, ddlDebug);
            TestHelper.runDdl(conn, DROP_ANCHORED_TYPES_TEST1_PACKAGE, ddlDebug);
        }
    }

    @Test
    public void anchoredTypesTest1() {
        boolean worked = true;
        PLSQLPackageType plsqlPackageType = null;
        try {
            plsqlPackageType = dtBuilder.buildPackages(conn, "", ANCHORED_TYPES_TEST4_PACKAGE).get(0);
        }
        catch (Exception e) {
            worked = false;
        }
        Assert.assertTrue((String)"ANCHORED_TYPES_TEST4 should parse", (boolean)worked);
        PLSQLType plsqlType1 = plsqlPackageType.getTypes().get(0);
        Assert.assertTrue((String)"WNAME's enclosedType is supposed to be resolved", (boolean)plsqlType1.isResolved());
        PLSQLType plsqlType2 = plsqlPackageType.getTypes().get(1);
        Assert.assertTrue((String)"ANCHORED_TYPE2's enclosedType is supposed to be resolved", (boolean)plsqlType2.isResolved());
        PLSQLCursorType cursorType = plsqlPackageType.getCursors().get(0);
        Assert.assertTrue((String)"ANCHORED_CURSOR is supposed to be resolved", (boolean)cursorType.isResolved());
        Assert.assertSame((String)"ANCHORED_TYPE2 is supposed to be identical to ANCHORED_CURSOR's return type", (Object)plsqlType2, (Object)cursorType.getEnclosedType());
        UnresolvedTypesVisitor visitor = new UnresolvedTypesVisitor();
        visitor.visit(plsqlPackageType);
        Assert.assertEquals((String)"ANCHORED_TYPES_TEST4 should not have any unresolved types", (long)0L, (long)visitor.getUnresolvedTypes().size());
        TableType tt1 = this.getTableType(cursorType);
        TableType tt2 = this.getTableType(plsqlPackageType.getCursors().get(1));
        TableType tt3 = this.getTableType(plsqlPackageType.getLocalVariables().get(0));
        TableType tt4 = this.getTableType(plsqlType2);
        Assert.assertEquals((String)("Expected types [" + cursorType + "] and [" + plsqlPackageType.getCursors().get(1) + "] " + "to have the same TableType instance"), (Object)tt1, (Object)tt2);
        Assert.assertEquals((String)("Expected types [" + plsqlPackageType.getCursors().get(1) + "] and [" + plsqlPackageType.getLocalVariables().get(0) + "] " + "to have the same TableType instance"), (Object)tt2, (Object)tt3);
        Assert.assertEquals((String)("Expected types [" + plsqlPackageType.getLocalVariables().get(0) + "] and [" + plsqlType2 + "] " + "to have the same TableType instance"), (Object)tt3, (Object)tt4);
    }

    protected TableType getTableType(CompositeDatabaseType owningType) {
        DatabaseType enclosedType = null;
        try {
            boolean done = false;
            while (!done) {
                if (owningType.getEnclosedType() != null) {
                    enclosedType = owningType.getEnclosedType();
                    Assert.assertTrue((String)("Expected composite enclosedType, but was [" + owningType.getTypeName() + "]"), (boolean)enclosedType.isComposite());
                    owningType = (CompositeDatabaseType)enclosedType;
                    continue;
                }
                done = true;
            }
            Assert.assertNotNull(enclosedType);
            Assert.assertTrue((String)("Expected TableType instance but was [" + enclosedType.getClass().getName() + "]"), (boolean)enclosedType.isTableType());
        }
        catch (Exception x) {
            Assert.fail((String)("An unexpected exception occurred attempting to retrieve TableType from type [" + owningType.getTypeName() + "].  Exception message: " + x.getMessage()));
        }
        return (TableType)enclosedType;
    }
}

