/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.mappings;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class ReturnInsertMetadata
extends ORMetadata {
    private Boolean m_returnOnly;

    public ReturnInsertMetadata() {
        super("<return-insert>");
    }

    public ReturnInsertMetadata(MetadataAnnotation returnInsert, MetadataAccessibleObject accessibleObject) {
        super(returnInsert, accessibleObject);
        this.m_returnOnly = (Boolean)returnInsert.getAttributeBooleanDefaultFalse("returnOnly");
    }

    public Boolean getReturnOnly() {
        return this.m_returnOnly;
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ReturnInsertMetadata) {
            ReturnInsertMetadata returnInsert = (ReturnInsertMetadata)objectToCompare;
            return this.valuesMatch(this.m_returnOnly, returnInsert.getReturnOnly());
        }
        return false;
    }

    public void process(MetadataDescriptor descriptor, DatabaseField field) {
        if (this.m_returnOnly != null && this.m_returnOnly.booleanValue()) {
            descriptor.addFieldForInsertReturnOnly(field);
        } else {
            descriptor.addFieldForInsert(field);
        }
    }

    public void setReturnOnly(Boolean returnOnly) {
        this.m_returnOnly = returnOnly;
    }
}

