/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.mappings.transformers.FieldTransformerAdapter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sessions.Session;

public class QNameFieldTransformer
extends FieldTransformerAdapter {
    public Object buildFieldValue(Object object, String fieldName, Session session) {
        if (object != null) {
            QName qName = null;
            if ("type/text()".equals(fieldName)) {
                if (object instanceof Result) {
                    qName = ((Result)object).getType();
                } else if (object instanceof Parameter) {
                    qName = ((Parameter)object).getType();
                } else if (object instanceof ProcedureOutputArgument) {
                    qName = ((ProcedureOutputArgument)object).getResultType();
                }
                if (qName != null) {
                    XMLDescriptor desc = (XMLDescriptor)session.getDescriptor(object);
                    String prefix = desc.getNamespaceResolver().resolveNamespaceURI(qName.getNamespaceURI());
                    if (prefix != null) {
                        return prefix + ":" + qName.getLocalPart();
                    }
                    return qName.toString();
                }
            }
        }
        return null;
    }
}

