/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class MetadataField
extends MetadataAnnotatedElement {
    public MetadataField(Field field, MetadataLogger logger) {
        super((AnnotatedElement)field, logger);
        this.setName(field.getName());
        this.setAttributeName(field.getName());
        this.setRelationType(field.getGenericType());
    }

    public MetadataField(Field field, XMLEntityMappings entityMappings) {
        super((AnnotatedElement)field, entityMappings);
        this.setName(field.getName());
        this.setAttributeName(field.getName());
        this.setRelationType(field.getGenericType());
    }

    protected Field getField() {
        return (Field)this.getAnnotatedElement();
    }

    public boolean isValidPersistenceField(boolean mustBeExplicit, MetadataDescriptor descriptor) {
        if (this.isValidPersistenceElement(mustBeExplicit, "FIELD", descriptor)) {
            return this.isValidPersistenceField(descriptor, this.hasDeclaredAnnotations(descriptor));
        }
        return false;
    }

    public boolean isValidPersistenceField(MetadataDescriptor descriptor, boolean userDecorated) {
        if (!this.isValidPersistenceElement(this.getField().getModifiers())) {
            if (userDecorated) {
                throw ValidationException.mappingMetadataAppliedToInvalidAttribute(this.getField(), descriptor.getJavaClass());
            }
            return false;
        }
        return true;
    }
}

