/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.GenerationType;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.InterfaceAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitDefaults;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.QuerySequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProject {
    private static final String DEFAULT_AUTO_GENERATOR = "SEQ_GEN";
    private static final String DEFAULT_TABLE_GENERATOR = "SEQ_GEN_TABLE";
    private static final String DEFAULT_SEQUENCE_GENERATOR = "SEQ_GEN_SEQUENCE";
    private static final String DEFAULT_IDENTITY_GENERATOR = "SEQ_GEN_IDENTITY";
    private boolean m_weaveEager;
    private boolean m_weavingEnabled;
    private PersistenceUnitInfo m_persistenceUnitInfo;
    private AbstractSession m_session;
    private MetadataLogger m_logger;
    private XMLPersistenceUnitMetadata m_persistenceUnitMetadata;
    private HashMap<URL, XMLEntityMappings> m_entityMappings;
    private HashMap<String, MappedSuperclassAccessor> m_mappedSuperclasses;
    private HashMap<String, ClassAccessor> m_allAccessors;
    private HashMap<String, EntityAccessor> m_entityAccessors;
    private HashMap<String, EmbeddableAccessor> m_embeddableAccessors;
    private HashMap<String, InterfaceAccessor> m_interfaceAccessors;
    private HashMap<String, NamedQueryMetadata> m_queries;
    private HashMap<String, SQLResultSetMappingMetadata> m_sqlResultSetMappings;
    private HashMap<Class, GeneratedValueMetadata> m_generatedValues;
    private HashMap<String, TableGeneratorMetadata> m_tableGenerators;
    private HashMap<String, SequenceGeneratorMetadata> m_sequenceGenerators;
    private HashMap<String, AbstractConverterMetadata> m_converters;
    private HashSet<EntityListenerMetadata> m_defaultListeners;
    private HashSet<ClassAccessor> m_accessorsWithRelationships;
    private HashSet<ClassAccessor> m_accessorsWithCustomizer;
    private HashSet<DirectAccessor> m_convertAccessors;

    public MetadataProject(PersistenceUnitInfo puInfo, AbstractSession session, boolean weavingEnabled, boolean weaveEager) {
        this.m_persistenceUnitInfo = puInfo;
        this.m_session = session;
        this.m_logger = new MetadataLogger(session);
        this.m_weavingEnabled = weavingEnabled;
        this.m_weaveEager = weaveEager;
        this.m_entityMappings = new LinkedHashMap<URL, XMLEntityMappings>();
        this.m_defaultListeners = new LinkedHashSet<EntityListenerMetadata>();
        this.m_queries = new HashMap();
        this.m_sqlResultSetMappings = new HashMap();
        this.m_mappedSuperclasses = new HashMap();
        this.m_allAccessors = new HashMap();
        this.m_entityAccessors = new HashMap();
        this.m_embeddableAccessors = new HashMap();
        this.m_interfaceAccessors = new HashMap();
        this.m_accessorsWithCustomizer = new HashSet();
        this.m_accessorsWithRelationships = new HashSet();
        this.m_generatedValues = new HashMap();
        this.m_tableGenerators = new HashMap();
        this.m_sequenceGenerators = new HashMap();
        this.m_converters = new HashMap();
        this.m_convertAccessors = new HashSet();
    }

    protected void addAccessor(ClassAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getDescriptor();
        if (this.m_persistenceUnitMetadata != null) {
            descriptor.setIgnoreAnnotations(this.m_persistenceUnitMetadata.isXMLMappingMetadataComplete());
            descriptor.setIgnoreDefaultMappings(this.m_persistenceUnitMetadata.excludeDefaultMappings());
            XMLPersistenceUnitDefaults persistenceUnitDefaults = this.m_persistenceUnitMetadata.getPersistenceUnitDefaults();
            if (persistenceUnitDefaults != null) {
                descriptor.setDefaultAccess(persistenceUnitDefaults.getAccess());
                descriptor.setDefaultSchema(persistenceUnitDefaults.getSchema());
                descriptor.setDefaultCatalog(persistenceUnitDefaults.getCatalog());
                descriptor.setIsCascadePersist(persistenceUnitDefaults.isCascadePersist());
            }
        }
        this.m_session.getProject().addDescriptor(descriptor.getClassDescriptor());
        this.m_allAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addAccessorWithCustomizer(ClassAccessor accessor) {
        this.m_accessorsWithCustomizer.add(accessor);
    }

    public void addAccessorWithRelationships(ClassAccessor accessor) {
        this.m_accessorsWithRelationships.add(accessor);
    }

    public void addAlias(String alias, MetadataDescriptor descriptor) {
        ClassDescriptor existingDescriptor = this.m_session.getProject().getDescriptorForAlias(alias);
        if (existingDescriptor != null) {
            throw ValidationException.nonUniqueEntityName(existingDescriptor.getJavaClassName(), descriptor.getJavaClassName(), alias);
        }
        descriptor.setAlias(alias);
        this.m_session.getProject().addAlias(alias, descriptor.getClassDescriptor());
    }

    public void addConvertAccessor(DirectAccessor accessor) {
        this.m_convertAccessors.add(accessor);
    }

    public void addConverter(AbstractConverterMetadata converter) {
        if (converter.shouldOverride(this.m_converters.get(converter.getName()))) {
            this.m_converters.put(converter.getName(), converter);
        }
    }

    public void addDefaultListener(EntityListenerMetadata defaultListener) {
        this.m_defaultListeners.add(defaultListener);
    }

    public void addEmbeddableAccessor(EmbeddableAccessor accessor) {
        this.addAccessor(accessor);
        accessor.getDescriptor().setIsEmbeddable();
        this.m_embeddableAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addEntityAccessor(EntityAccessor accessor) {
        this.addAccessor(accessor);
        this.m_entityAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addEntityMappings(XMLEntityMappings entityMappings) {
        this.m_entityMappings.put(entityMappings.getMappingFile(), entityMappings);
    }

    public void addGeneratedValue(GeneratedValueMetadata generatedvalue, Class entityClass) {
        this.m_generatedValues.put(entityClass, generatedvalue);
    }

    public void addInterfaceAccessor(InterfaceAccessor accessor) {
        this.m_interfaceAccessors.put(accessor.getJavaClassName(), accessor);
        this.m_session.getProject().addDescriptor(accessor.getDescriptor().getClassDescriptor());
    }

    public void addMappedSuperclass(String className, MappedSuperclassAccessor mappedSuperclass) {
        if (this.m_mappedSuperclasses.containsKey(className)) {
            this.m_mappedSuperclasses.get(className).merge(mappedSuperclass);
        } else {
            this.m_mappedSuperclasses.put(className, mappedSuperclass);
        }
    }

    public void addQuery(NamedQueryMetadata query) {
        if (query.shouldOverride(this.m_queries.get(query.getName()))) {
            this.m_queries.put(query.getName(), query);
        }
    }

    public void addSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator) {
        String name = sequenceGenerator.getName();
        if (name.equals(DEFAULT_TABLE_GENERATOR)) {
            throw ValidationException.sequenceGeneratorUsingAReservedName(DEFAULT_TABLE_GENERATOR, sequenceGenerator.getLocation());
        }
        if (name.equals(DEFAULT_IDENTITY_GENERATOR)) {
            throw ValidationException.sequenceGeneratorUsingAReservedName(DEFAULT_IDENTITY_GENERATOR, sequenceGenerator.getLocation());
        }
        TableGeneratorMetadata tableGenerator = this.m_tableGenerators.get(name);
        if (tableGenerator != null) {
            throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified(name, sequenceGenerator.getLocation(), tableGenerator.getLocation());
        }
        for (TableGeneratorMetadata otherTableGenerator : this.m_tableGenerators.values()) {
            if (!otherTableGenerator.getPkColumnValue().equals(sequenceGenerator.getSequenceName()) || otherTableGenerator.getPkColumnValue().length() <= 0) continue;
            throw ValidationException.conflictingSequenceNameAndTablePkColumnValueSpecified(sequenceGenerator.getSequenceName(), sequenceGenerator.getLocation(), otherTableGenerator.getLocation());
        }
        if (sequenceGenerator.shouldOverride(this.m_sequenceGenerators.get(name))) {
            this.m_sequenceGenerators.put(sequenceGenerator.getName(), sequenceGenerator);
        }
    }

    public void addSQLResultSetMapping(SQLResultSetMappingMetadata sqlResultSetMapping) {
        if (sqlResultSetMapping.shouldOverride(this.m_sqlResultSetMappings.get(sqlResultSetMapping.getName()))) {
            this.m_sqlResultSetMappings.put(sqlResultSetMapping.getName(), sqlResultSetMapping);
        }
    }

    public void addTableGenerator(TableGeneratorMetadata tableGenerator, String defaultCatalog, String defaultSchema) {
        this.processTable(tableGenerator, "SEQUENCE", defaultCatalog, defaultSchema);
        String generatorName = tableGenerator.getGeneratorName();
        if (generatorName.equals(DEFAULT_SEQUENCE_GENERATOR)) {
            throw ValidationException.tableGeneratorUsingAReservedName(DEFAULT_SEQUENCE_GENERATOR, tableGenerator.getLocation());
        }
        if (generatorName.equals(DEFAULT_IDENTITY_GENERATOR)) {
            throw ValidationException.tableGeneratorUsingAReservedName(DEFAULT_IDENTITY_GENERATOR, tableGenerator.getLocation());
        }
        SequenceGeneratorMetadata otherSequenceGenerator = this.m_sequenceGenerators.get(generatorName);
        if (otherSequenceGenerator != null) {
            throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified(generatorName, otherSequenceGenerator.getLocation(), tableGenerator.getLocation());
        }
        for (SequenceGeneratorMetadata sequenceGenerator : this.m_sequenceGenerators.values()) {
            if (!sequenceGenerator.getSequenceName().equals(tableGenerator.getPkColumnValue()) || sequenceGenerator.getSequenceName().length() <= 0) continue;
            throw ValidationException.conflictingSequenceNameAndTablePkColumnValueSpecified(sequenceGenerator.getSequenceName(), sequenceGenerator.getLocation(), tableGenerator.getLocation());
        }
        if (tableGenerator.shouldOverride(this.m_tableGenerators.get(generatorName))) {
            this.m_tableGenerators.put(generatorName, tableGenerator);
        }
    }

    public ClassAccessor getAccessor(String className) {
        return this.m_allAccessors.get(className);
    }

    public Set<ClassAccessor> getAccessorsWithCustomizer() {
        return this.m_accessorsWithCustomizer;
    }

    public Set<ClassAccessor> getAccessorsWithRelationships() {
        return this.m_accessorsWithRelationships;
    }

    public Collection<ClassAccessor> getAllAccessors() {
        return this.m_allAccessors.values();
    }

    public AbstractConverterMetadata getConverter(String name) {
        return this.m_converters.get(name);
    }

    public Set<EntityListenerMetadata> getDefaultListeners() {
        return this.m_defaultListeners;
    }

    public EmbeddableAccessor getEmbeddableAccessor(String className) {
        return this.m_embeddableAccessors.get(className);
    }

    public EntityAccessor getEntityAccessor(String className) {
        return this.m_entityAccessors.get(className);
    }

    public Collection<EntityAccessor> getEntityAccessors() {
        return this.m_entityAccessors.values();
    }

    public Collection<XMLEntityMappings> getEntityMappings() {
        return this.m_entityMappings.values();
    }

    public InterfaceAccessor getInterfaceAccessor(String className) {
        return this.m_interfaceAccessors.get(className);
    }

    public MetadataLogger getLogger() {
        return this.m_logger;
    }

    public MappedSuperclassAccessor getMappedSuperclass(Class cls) {
        return this.m_mappedSuperclasses.get(cls.getName());
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.m_persistenceUnitInfo;
    }

    public XMLPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.m_persistenceUnitMetadata;
    }

    public List<StructConverterMetadata> getStructConverters() {
        ArrayList<StructConverterMetadata> structConverters = new ArrayList<StructConverterMetadata>();
        for (AbstractConverterMetadata converter : this.m_converters.values()) {
            if (!converter.isStructConverter()) continue;
            structConverters.add((StructConverterMetadata)converter);
        }
        return structConverters;
    }

    public Collection<String> getWeavableClassNames() {
        return Collections.unmodifiableCollection(this.m_allAccessors.keySet());
    }

    public boolean hasConverter(String name) {
        return this.m_converters.containsKey(name);
    }

    public boolean hasEmbeddable(Class cls) {
        return this.m_embeddableAccessors.containsKey(cls.getName());
    }

    public boolean hasEntity(Class cls) {
        return this.m_entityAccessors.containsKey(cls.getName());
    }

    public boolean hasInterface(Class cls) {
        return this.m_interfaceAccessors.containsKey(cls.getName());
    }

    public boolean hasMappedSuperclass(Class cls) {
        return this.m_mappedSuperclasses.containsKey(cls.getName());
    }

    public boolean isWeavingEnabled() {
        return this.m_weavingEnabled;
    }

    public void process() {
        this.processConvertAccessors();
        this.processSequencing();
        this.processAccessorsWithRelationships();
        this.processInterfaceAccessors();
    }

    protected void processAccessorsWithRelationships() {
        for (ClassAccessor classAccessor : this.getAccessorsWithRelationships()) {
            for (RelationshipAccessor accessor : classAccessor.getDescriptor().getRelationshipAccessors()) {
                accessor.processRelationship();
            }
        }
    }

    protected void processConvertAccessors() {
        for (DirectAccessor accessor : this.m_convertAccessors) {
            accessor.processConvert();
        }
    }

    protected void processInterfaceAccessors() {
        for (EntityAccessor accessor : this.getEntityAccessors()) {
            for (Class<?> interfaceClass : accessor.getJavaClass().getInterfaces()) {
                if (!this.m_interfaceAccessors.containsKey(interfaceClass.getName())) continue;
                this.m_interfaceAccessors.get(interfaceClass.getName()).addEntityAccessor(accessor);
            }
        }
    }

    public void processQueries(ClassLoader loader) {
        for (SQLResultSetMappingMetadata sqlResultSetMapping : this.m_sqlResultSetMappings.values()) {
            sqlResultSetMapping.process(this.m_session, loader);
        }
        for (NamedQueryMetadata query : this.m_queries.values()) {
            query.process(this.m_session, loader);
        }
    }

    protected void processSequencing() {
        if (!this.m_generatedValues.isEmpty()) {
            Sequence sequence;
            Integer allocationSize;
            String seqName;
            DatabaseLogin login = this.m_session.getProject().getLogin();
            Sequence defaultAutoSequence = null;
            Sequence defaultTableSequence = new TableSequence(DEFAULT_TABLE_GENERATOR);
            NativeSequence defaultObjectNativeSequence = new NativeSequence(DEFAULT_SEQUENCE_GENERATOR, false);
            NativeSequence defaultIdentityNativeSequence = new NativeSequence(DEFAULT_IDENTITY_GENERATOR, 1, true);
            Hashtable<String, QuerySequence> sequences = new Hashtable<String, QuerySequence>();
            for (SequenceGeneratorMetadata sequenceGenerator : this.m_sequenceGenerators.values()) {
                String sequenceGeneratorName = sequenceGenerator.getName();
                seqName = sequenceGenerator.getSequenceName() != null && !sequenceGenerator.getSequenceName().equals("") ? sequenceGenerator.getSequenceName() : sequenceGeneratorName;
                allocationSize = sequenceGenerator.getAllocationSize();
                if (allocationSize == null) {
                    allocationSize = new Integer(50);
                }
                NativeSequence sequence2 = new NativeSequence(seqName, (int)allocationSize, false);
                sequences.put(sequenceGeneratorName, sequence2);
                if (sequenceGeneratorName.equals(DEFAULT_AUTO_GENERATOR)) {
                    defaultAutoSequence = sequence2;
                    continue;
                }
                if (!sequenceGeneratorName.equals(DEFAULT_SEQUENCE_GENERATOR)) continue;
                defaultObjectNativeSequence = sequence2;
            }
            for (TableGeneratorMetadata tableGenerator : this.m_tableGenerators.values()) {
                Integer initialValue;
                String tableGeneratorName = tableGenerator.getGeneratorName();
                seqName = tableGenerator.getPkColumnValue() != null && !tableGenerator.getPkColumnValue().equals("") ? tableGenerator.getPkColumnValue() : tableGeneratorName;
                allocationSize = tableGenerator.getAllocationSize();
                if (allocationSize == null) {
                    allocationSize = new Integer(50);
                }
                if ((initialValue = tableGenerator.getInitialValue()) == null) {
                    initialValue = new Integer(0);
                }
                sequence = new TableSequence(seqName, (int)allocationSize, initialValue);
                sequences.put(tableGeneratorName, (QuerySequence)sequence);
                ((TableSequence)sequence).setTable(tableGenerator.getDatabaseTable());
                if (tableGenerator.getPkColumnName() != null && !tableGenerator.getPkColumnName().equals("")) {
                    ((TableSequence)sequence).setNameFieldName(tableGenerator.getPkColumnName());
                }
                if (tableGenerator.getValueColumnName() != null && !tableGenerator.getValueColumnName().equals("")) {
                    ((TableSequence)sequence).setCounterFieldName(tableGenerator.getValueColumnName());
                }
                if (tableGeneratorName.equals(DEFAULT_AUTO_GENERATOR)) {
                    defaultAutoSequence = sequence;
                    continue;
                }
                if (!tableGeneratorName.equals(DEFAULT_TABLE_GENERATOR)) continue;
                defaultTableSequence = sequence;
            }
            boolean usesAuto = false;
            for (Class entityClass : this.m_generatedValues.keySet()) {
                MetadataDescriptor descriptor = this.m_allAccessors.get(entityClass.getName()).getDescriptor();
                GeneratedValueMetadata generatedValue = this.m_generatedValues.get(entityClass);
                String generatorName = generatedValue.getGenerator();
                if (generatorName == null) {
                    generatorName = "";
                }
                sequence = null;
                if (!generatorName.equals("")) {
                    sequence = (Sequence)sequences.get(generatorName);
                }
                if (sequence == null) {
                    Enum strategy = generatedValue.getStrategy();
                    if (strategy == null || strategy.name().equals(GenerationType.AUTO.name())) {
                        usesAuto = true;
                    } else if (strategy.name().equals(GenerationType.TABLE.name())) {
                        if (generatorName.equals("")) {
                            sequence = defaultTableSequence;
                        } else {
                            sequence = (Sequence)defaultTableSequence.clone();
                            sequence.setName(generatorName);
                        }
                    } else if (strategy.name().equals(GenerationType.SEQUENCE.name())) {
                        if (generatorName.equals("")) {
                            sequence = defaultObjectNativeSequence;
                        } else {
                            sequence = (Sequence)defaultObjectNativeSequence.clone();
                            sequence.setName(generatorName);
                        }
                    } else if (strategy.name().equals(GenerationType.IDENTITY.name())) {
                        if (generatorName.equals("")) {
                            sequence = defaultIdentityNativeSequence;
                        } else {
                            sequence = (Sequence)defaultIdentityNativeSequence.clone();
                            sequence.setName(generatorName);
                        }
                    }
                }
                if (sequence != null) {
                    descriptor.setSequenceNumberName(sequence.getName());
                    login.addSequence(sequence);
                    continue;
                }
                String seqName2 = generatorName.equals("") ? (defaultAutoSequence != null ? defaultAutoSequence.getName() : DEFAULT_AUTO_GENERATOR) : generatorName;
                descriptor.setSequenceNumberName(seqName2);
            }
            if (usesAuto && defaultAutoSequence != null) {
                login.setDefaultSequence(defaultAutoSequence);
            }
        }
    }

    public void processTable(TableMetadata table, String defaultName, String defaultCatalog, String defaultSchema) {
        String name = MetadataHelper.getName(table.getName(), defaultName, table.getNameContext(), this.m_logger, table.getLocation());
        String catalog = MetadataHelper.getName(table.getCatalog(), defaultCatalog, table.getCatalogContext(), this.m_logger, table.getLocation());
        String schema = MetadataHelper.getName(table.getSchema(), defaultSchema, table.getSchemaContext(), this.m_logger, table.getLocation());
        String tableName = new String(name);
        if (!schema.equals("")) {
            tableName = schema + "." + tableName;
        }
        if (!catalog.equals("")) {
            tableName = catalog + "." + tableName;
        }
        table.setFullyQualifiedTableName(tableName);
        table.processUniqueConstraints();
    }

    public void setPersistenceUnitMetadata(XMLPersistenceUnitMetadata persistenceUnitMetadata) {
        if (this.m_persistenceUnitMetadata == null) {
            this.m_persistenceUnitMetadata = persistenceUnitMetadata;
        } else {
            this.m_persistenceUnitMetadata.merge(persistenceUnitMetadata);
        }
    }

    public void setWeavingEnabled(boolean weavingEnabled) {
        this.m_weavingEnabled = weavingEnabled;
    }

    public boolean weaveEager() {
        return this.m_weaveEager;
    }
}

