/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.io.Serializable;
import java.security.AccessControlException;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;

public class AddRegistrationRequest
implements Serializable {
    private static final long serialVersionUID = -2671778516104780091L;
    ID targetID;
    String service;
    String filter;
    AccessControlException acc;
    AddRegistrationRequest parent;
    private boolean done = false;
    private transient Vector requests = null;

    public AddRegistrationRequest(ID targetID, String service, String filter, AddRegistrationRequest parent) {
        this.targetID = null;
        this.parent = null;
        this.service = service;
        this.filter = filter;
    }

    public AddRegistrationRequest(String service, String filter, Vector requests) {
        this.parent = null;
        this.targetID = null;
        Assert.isNotNull((Object)service);
        this.service = service;
        this.filter = filter;
        this.requests = requests;
        if (requests != null) {
            requests.add(this);
        }
    }

    public String getService() {
        return this.service;
    }

    public String getFilter() {
        return this.filter;
    }

    public Integer getId() {
        return System.identityHashCode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForResponse(long timeout) {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + timeout;
        AddRegistrationRequest addRegistrationRequest = this;
        synchronized (addRegistrationRequest) {
            while (!this.done && endTime >= System.currentTimeMillis()) {
                try {
                    this.wait(timeout / 10L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForAllResponses(long timeout) {
        if (this.requests != null) {
            long startTime = System.currentTimeMillis();
            long endTime = startTime + timeout;
            Vector vector = this.requests;
            synchronized (vector) {
                while (this.requests.size() > 0 && endTime >= System.currentTimeMillis()) {
                    try {
                        this.requests.wait(timeout / 10L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyResponse(AccessControlException exception) {
        if (this.requests != null) {
            Vector vector = this.requests;
            synchronized (vector) {
                this.requests.remove(this);
                this.requests.notify();
            }
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public AccessControlException getException() {
        return this.acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResponse(ID from, AccessControlException exception) {
        if (this.targetID == null || this.targetID.equals((Object)from)) {
            this.acc = exception;
            AddRegistrationRequest addRegistrationRequest = this;
            synchronized (addRegistrationRequest) {
                this.done = true;
                if (this.parent != null) {
                    this.parent.notifyResponse(from, exception);
                } else {
                    AddRegistrationRequest addRegistrationRequest2 = this;
                    synchronized (addRegistrationRequest2) {
                        this.notify();
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("AddRegistrationRequest[");
        buf.append("service=").append(this.service).append(";filter=").append(this.filter).append("]");
        return buf.toString();
    }
}

