/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;
import org.eclipse.ecf.server.generic.app.NamedGroup;

public class Connector {
    public static final int DEFAULT_PORT = TCPServerSOContainer.DEFAULT_PORT;
    public static final int DEFAULT_TIMEOUT = TCPServerSOContainer.DEFAULT_KEEPALIVE;
    public static final String DEFAULT_HOSTNAME = TCPServerSOContainer.DEFAULT_HOST;
    public static final String DEFAULT_SERVERNAME = TCPServerSOContainer.DEFAULT_NAME;
    public static final String DEFAULT_PROTOCOL = "ecftcp";
    int port = DEFAULT_PORT;
    int timeout = DEFAULT_TIMEOUT;
    String protocol = "ecftcp";
    String hostname = DEFAULT_HOSTNAME;
    boolean discovery = false;
    List groups = new ArrayList();

    public Connector(String protocol, String host, int port, int timeout, boolean discovery) {
        if (protocol != null && !protocol.equals("")) {
            this.protocol = protocol;
        }
        if (host != null && !host.equals("")) {
            this.hostname = host;
        } else {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                this.hostname = this.getHostNameForAddressWithoutLookup(addr);
            }
            catch (Exception e) {
                this.hostname = "localhost";
            }
        }
        this.port = port;
        this.timeout = timeout;
        this.discovery = discovery;
    }

    private String getHostNameForAddressWithoutLookup(InetAddress inetAddress) {
        String inetAddressStr = inetAddress.toString();
        int slashPos = inetAddressStr.indexOf(47);
        if (slashPos == 0) {
            return inetAddressStr.substring(1);
        }
        return inetAddressStr.substring(0, slashPos);
    }

    public Connector(String protocol, String host, int port, int timeout) {
        this(protocol, host, port, timeout, false);
    }

    public boolean shouldRegisterForDiscovery() {
        return this.discovery;
    }

    public boolean addGroup(NamedGroup grp) {
        if (grp == null) {
            return false;
        }
        for (NamedGroup namedGroup : this.groups) {
            if (!namedGroup.getName().equals(grp.getName())) continue;
            return false;
        }
        this.groups.add(grp);
        grp.setParent(this);
        return true;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public List getGroups() {
        return this.groups;
    }

    public String getID() {
        return String.valueOf(this.getProtocol()) + "://" + this.getHostname() + ":" + this.getPort();
    }
}

