/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;

class CloseListener
implements PacketListener {
    private final InBandBytestreamManager manager;
    private final PacketFilter closeFilter = new AndFilter(new PacketTypeFilter(Close.class), new IQTypeFilter(IQ.Type.SET));

    protected CloseListener(InBandBytestreamManager manager) {
        this.manager = manager;
    }

    public void processPacket(Packet packet) {
        Close closeRequest = (Close)packet;
        InBandBytestreamSession ibbSession = this.manager.getSessions().get(closeRequest.getSessionID());
        if (ibbSession == null) {
            this.manager.replyItemNotFoundPacket(closeRequest);
        } else {
            ibbSession.closeByPeer(closeRequest);
            this.manager.getSessions().remove(closeRequest.getSessionID());
        }
    }

    protected PacketFilter getFilter() {
        return this.closeFilter;
    }
}

