/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.ui.EditorHelper;
import org.eclipse.ecf.internal.example.collab.ui.hyperlink.EclipseCollabHyperlinkDetector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EclipseCollabHyperlink
implements IHyperlink {
    private final IRegion region;
    private final String fileName;
    private final EclipseCollabHyperlinkDetector.Selection selection;

    public EclipseCollabHyperlink(IRegion detectedRegion, String fileName, EclipseCollabHyperlinkDetector.Selection selection) {
        this.region = detectedRegion;
        this.fileName = fileName;
        this.selection = selection;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow ww = wb.getActiveWorkbenchWindow();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.fileName));
        if (file != null) {
            EditorHelper eh = new EditorHelper(ww);
            try {
                eh.openAndSelectForFile(file, this.selection == null ? 0 : this.selection.getStart(), this.selection == null ? 0 : this.selection.getEnd() - this.selection.getStart());
            }
            catch (Exception e) {
                ClientPlugin.log(Messages.EclipseCollabHyperlink_EXCEPTION_OPEN_EDITOR, e);
            }
        } else {
            MessageDialog.openInformation((Shell)ww.getShell(), (String)Messages.EclipseCollabHyperlink_EXCEPTION_OPEN_EDITOR_TITLE, (String)NLS.bind((String)Messages.EclipseCollabHyperlink_MESSAGE_EXCEPTION_OPEN_EDITOR, (Object)this.fileName));
        }
    }
}

