/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean addUnique(Collection collection, Object value) {
        if (collection.contains(value)) {
            return false;
        }
        return collection.add(value);
    }

    public static boolean addAllUnique(Collection collection, Collection values) {
        boolean changed = false;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            changed = CollectionUtils.addUnique(collection, iter.next());
        }
        return changed;
    }

    public static Collection intersection(Collection c1, Collection c2) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] members_c1 = c1.toArray();
        int i = 0;
        while (i < members_c1.length) {
            if (c2.contains(members_c1[i])) {
                list.add(members_c1[i]);
            }
            ++i;
        }
        return list;
    }

    public static Collection union(Collection c1, Collection c2) {
        ArrayList list = new ArrayList();
        CollectionUtils.addAllUnique(list, c1);
        CollectionUtils.addAllUnique(list, c2);
        return list;
    }

    public static Collection rightDifference(Collection c1, Collection c2) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] members_c1 = c1.toArray();
        int i = 0;
        while (i < members_c1.length) {
            if (!c2.contains(members_c1[i])) {
                result.add(members_c1[i]);
            }
            ++i;
        }
        return result;
    }

    public static Collection leftDifference(Collection c1, Collection c2) {
        return CollectionUtils.rightDifference(c2, c1);
    }

    public static Collection difference(Collection c1, Collection c2) {
        return CollectionUtils.union(CollectionUtils.leftDifference(c1, c2), CollectionUtils.rightDifference(c1, c2));
    }

    public static void addValue(Map map, Object key, Object value) {
        ArrayList<Object> values = (ArrayList<Object>)map.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
        }
        values.add(value);
        map.put(key, values);
    }

    public static void addValue(Map map, Object key, Object value, int maxEntries) {
        ArrayList<Object> values = (ArrayList<Object>)map.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
        }
        values.add(value);
        while (values.size() > maxEntries) {
            values.remove(0);
        }
        map.put(key, values);
    }

    public static void removeValue(Map map, Object[] keys, Object value) {
        int i = 0;
        while (i < keys.length) {
            List values = (List)map.get(keys[i]);
            if (values != null) {
                values.remove(value);
                if (values.isEmpty()) {
                    map.remove(keys[i]);
                } else {
                    map.put(keys[i], values);
                }
            }
            ++i;
        }
    }
}

