/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.user.User;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.example.collab.share.SharedObjectEventListener;
import org.eclipse.ecf.internal.example.collab.ClientEntry;
import org.eclipse.ecf.internal.example.collab.CollabClient;
import org.eclipse.ecf.internal.example.collab.Messages;

public class SharedObjectContainerUI {
    public static final String JOIN_TIME_FORMAT = "hh:mm:ss a z";
    public static final String FILE_DIRECTORY = "received_files";
    public static final String ECFDIRECTORY = "ECF_received_files/";
    public static final String COLLAB_SHARED_OBJECT_ID = "chat";
    ISharedObjectContainer soc = null;
    CollabClient collabclient = null;

    public SharedObjectContainerUI(CollabClient client, ISharedObjectContainer soc) {
        this.collabclient = client;
        this.soc = soc;
    }

    protected String getSharedFileDirectoryForProject(IResource proj) {
        String eclipseDir = Platform.getLocation().lastSegment();
        if (proj == null) {
            return String.valueOf(eclipseDir) + "/" + ECFDIRECTORY;
        }
        return FILE_DIRECTORY;
    }

    protected IUser getUserData(String containerType, ID clientID, String usernick, IResource project) {
        HashMap<String, String> topElements = new HashMap<String, String>();
        topElements.put(Messages.SharedObjectContainerUI_PROJECT_LABEL, CollabClient.getNameForResource(project));
        SimpleDateFormat sdf = new SimpleDateFormat(JOIN_TIME_FORMAT);
        topElements.put(Messages.SharedObjectContainerUI_TIME_LABEL, sdf.format(new Date()));
        try {
            topElements.put(Messages.SharedObjectContainerUI_LANGUAGE_LABEL, System.getProperty("user.language"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            topElements.put(Messages.SharedObjectContainerUI_TIME_ZONE_LABEL, System.getProperty("user.timezone"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            topElements.put(Messages.SharedObjectContainerUI_OS_LABEL, Platform.getOS());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            topElements.put("Username", System.getProperty("user.name"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            topElements.put("Hostname/IP", InetAddress.getLocalHost().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new User(clientID, usernick, usernick, topElements);
    }

    void addObjectToClient(ISharedObjectContainer soContainer, ClientEntry client, String username, IResource proj) throws Exception {
        IResource project = proj == null ? CollabClient.getWorkspace() : proj;
        IUser user = this.getUserData(client.getClass().getName(), client.getContainer().getID(), username, proj);
        this.createAndAddSharedObject(soContainer, client, project, user, this.getSharedFileDirectoryForProject(project));
    }

    public void setup(ISharedObjectContainer soContainer, final ClientEntry newClientEntry, final IResource resource, String username) throws Exception {
        this.addObjectToClient(soContainer, newClientEntry, username, resource);
        this.soc.addListener(new IContainerListener(){

            public void handleEvent(IContainerEvent evt) {
                if (evt instanceof IContainerDisconnectedEvent || evt instanceof IContainerEjectedEvent) {
                    ID departedContainerID = evt instanceof IContainerDisconnectedEvent ? ((IContainerDisconnectedEvent)evt).getTargetID() : ((IContainerEjectedEvent)evt).getTargetID();
                    ID connectedID = newClientEntry.getContainer().getConnectedID();
                    if ((connectedID == null || connectedID.equals((Object)departedContainerID)) && !newClientEntry.isDisposed()) {
                        SharedObjectContainerUI.this.collabclient.disposeClient(resource, newClientEntry);
                    }
                }
            }
        });
    }

    protected void createAndAddSharedObject(ISharedObjectContainer soContainer, final ClientEntry client, final IResource proj, IUser user, String fileDir) throws Exception {
        EclipseCollabSharedObject sharedObject = new EclipseCollabSharedObject((IContainer)soContainer, proj, user, fileDir);
        sharedObject.setListener(new SharedObjectEventListener(){

            @Override
            public void memberRemoved(ID member) {
                ID groupID = client.getContainer().getConnectedID();
                if (member.equals((Object)groupID) && !client.isDisposed()) {
                    SharedObjectContainerUI.this.collabclient.disposeClient(proj, client);
                }
            }

            @Override
            public void memberAdded(ID member) {
            }

            @Override
            public void otherActivated(ID other) {
            }

            @Override
            public void otherDeactivated(ID other) {
            }

            @Override
            public void windowClosing() {
                ID groupID = client.getContainer().getConnectedID();
                CollabClient.removeClientForResource(proj, groupID);
            }
        });
        ID newID = IDFactory.getDefault().createStringID(COLLAB_SHARED_OBJECT_ID);
        soContainer.getSharedObjectManager().addSharedObject(newID, (ISharedObject)sharedObject, new HashMap());
        client.setSharedObject(sharedObject);
    }
}

