/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.examples.internal.eventadmin.app;

import java.util.Map;
import java.util.Properties;
import org.eclipse.ecf.examples.internal.eventadmin.app.NonSerializable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class TestSender
implements Runnable {
    private static final long DEFAULT_WAITTIME = 2000L;
    private long waittime = 2000L;
    private EventAdmin eventAdmin;
    private String[] topics;
    private String sender;
    private boolean done = false;
    private long messageCounter = 0L;

    public TestSender(EventAdmin eventAdmin, String[] topics, String sender) {
        this.eventAdmin = eventAdmin;
        this.topics = topics;
        this.sender = sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TestSender testSender = this;
        synchronized (testSender) {
            int i = 0;
            while (!this.done) {
                try {
                    this.wait(this.waittime);
                    Properties msgProps = new Properties();
                    msgProps.put("message", "message #" + this.messageCounter++);
                    msgProps.put("sender", this.sender);
                    String topic = this.topics[i++ % this.topics.length];
                    if (topic.equals("defaultTopic")) {
                        msgProps.put("nonserializable", new NonSerializable("MessageCnt: " + this.messageCounter));
                    }
                    this.eventAdmin.postEvent(new Event(topic, (Map)msgProps));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TestSender testSender = this;
        synchronized (testSender) {
            this.done = true;
            this.notifyAll();
        }
    }
}

