/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketAddress;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.IConnectHandlerPolicy;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerGroupManager;
import org.eclipse.ecf.provider.comm.DisconnectEvent;
import org.eclipse.ecf.provider.comm.IAsynchConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.ISynchConnection;
import org.eclipse.ecf.provider.generic.ContainerMessage;
import org.eclipse.ecf.provider.generic.SOContainer;
import org.eclipse.ecf.provider.generic.gmm.Member;

public class ServerSOContainer
extends SOContainer
implements ISharedObjectContainerGroupManager {
    protected IConnectHandlerPolicy connectHandlerPolicy;

    public ServerSOContainer(ISharedObjectContainerConfig config) {
        super(config);
    }

    public boolean isGroupManager() {
        return true;
    }

    public ID getConnectedID() {
        return this.getID();
    }

    public void disconnect() {
        this.ejectAllGroupMembers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejectGroupMember(ID memberID, Serializable reason) {
        if (memberID == null) {
            return;
        }
        ISynchConnection conn = null;
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            conn = this.getSynchConnectionForID(memberID);
            if (conn == null) {
                return;
            }
            try {
                conn.sendSynch(memberID, ServerSOContainer.serialize(ContainerMessage.createLeaveGroupMessage(this.getID(), memberID, this.getNextSequenceNumber(), reason)));
            }
            catch (Exception e) {
                this.traceStack("Exception in ejectGroupMember.sendAsynch()", e);
            }
            this.handleLeave(memberID, conn);
        }
        this.fireContainerEvent((IContainerEvent)new ContainerEjectedEvent(memberID, this.getID(), reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejectAllGroupMembers(Serializable reason) {
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            Object[] members = this.groupManager.getMembers();
            int i = 0;
            while (i < members.length) {
                this.ejectGroupMember(((Member)members[i]).getID(), reason);
                ++i;
            }
        }
    }

    public void dispose() {
        this.ejectAllGroupMembers(null);
        super.dispose();
    }

    public void connect(ID groupID, IConnectContext joinContext) throws ContainerConnectException {
        ContainerConnectException e = new ContainerConnectException("Server container cannot connect");
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectPolicy(IConnectHandlerPolicy policy) {
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            this.connectHandlerPolicy = policy;
        }
    }

    protected void queueContainerMessage(ContainerMessage message) throws IOException {
        if (message.getToContainerID() == null) {
            this.queueToAll(message);
        } else {
            IAsynchConnection conn = this.getConnectionForID(message.getToContainerID());
            if (conn != null) {
                conn.sendAsynch(message.getToContainerID(), ServerSOContainer.serialize(message));
            }
        }
    }

    protected void forwardToRemote(ID from, ID to, ContainerMessage data) throws IOException {
        this.queueContainerMessage(new ContainerMessage(from, to, this.getNextSequenceNumber(), data.getData()));
    }

    protected void forwardExcluding(ID from, ID excluding, ContainerMessage data) throws IOException {
        if (excluding == null) {
            this.queueContainerMessage(new ContainerMessage(from, null, this.getNextSequenceNumber(), data.getData()));
        } else {
            Object[] ms = this.groupManager.getMembers();
            int i = 0;
            while (i < ms.length) {
                IAsynchConnection conn;
                Member m = (Member)ms[i];
                ID oldID = m.getID();
                if (!excluding.equals((Object)oldID) && !from.equals((Object)oldID) && (conn = (IAsynchConnection)m.getData()) != null) {
                    try {
                        conn.sendAsynch(oldID, ServerSOContainer.serialize(new ContainerMessage(from, oldID, this.getNextSequenceNumber(), data.getData())));
                    }
                    catch (IOException e) {
                        this.traceStack("Exception in forwardExcluding from " + from + " with oldID " + oldID, e);
                    }
                }
                ++i;
            }
        }
    }

    protected void handleViewChangeMessage(ContainerMessage mess) throws IOException {
        this.debug("handleViewChangeMessage(" + mess + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContainerMessage acceptNewClient(Socket socket, String target, Serializable data, ISynchAsynchConnection conn) {
        this.debug("acceptNewClient(" + socket + "," + target + "," + data + "," + conn + ")");
        ContainerMessage connectMessage = null;
        ID remoteID = null;
        try {
            connectMessage = (ContainerMessage)data;
            if (connectMessage == null) {
                throw new NullPointerException("Connect message cannot be null");
            }
            remoteID = connectMessage.getFromContainerID();
            if (remoteID == null) {
                throw new NullPointerException("fromID cannot be null");
            }
            ContainerMessage.JoinGroupMessage jgm = (ContainerMessage.JoinGroupMessage)connectMessage.getData();
            if (jgm == null) {
                throw new NullPointerException("Join group message cannot be null");
            }
            ID[] memberIDs = null;
            Object object = this.getGroupMembershipLock();
            synchronized (object) {
                if (this.isClosing) {
                    IllegalStateException e = new IllegalStateException("Server container is closing");
                    throw e;
                }
                this.checkJoin(socket.getRemoteSocketAddress(), remoteID, target, jgm.getData());
                ISynchConnection oldConn = this.getSynchConnectionForID(remoteID);
                if (oldConn != null) {
                    this.handleLeave(remoteID, oldConn);
                }
                if (this.addNewRemoteMember(remoteID, conn)) {
                    try {
                        this.forwardExcluding(this.getID(), remoteID, ContainerMessage.createViewChangeMessage(this.getID(), remoteID, this.getNextSequenceNumber(), new ID[]{remoteID}, true, null));
                    }
                    catch (IOException e) {
                        this.traceStack("Exception in acceptNewClient sending view change message", e);
                    }
                } else {
                    ConnectException e = new ConnectException("server refused connection");
                    throw e;
                }
                memberIDs = this.groupManager.getMemberIDs();
                conn.start();
            }
            this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), remoteID));
            return ContainerMessage.createViewChangeMessage(this.getID(), remoteID, this.getNextSequenceNumber(), memberIDs, true, null);
        }
        catch (Exception e) {
            this.traceStack("Exception in acceptNewClient(" + socket + "," + target + "," + data + "," + conn, e);
            return ContainerMessage.createViewChangeMessage(this.getID(), remoteID, this.getNextSequenceNumber(), null, false, e);
        }
    }

    protected Object checkJoin(SocketAddress saddr, ID fromID, String target, Serializable data) throws Exception {
        if (this.connectHandlerPolicy != null) {
            return this.connectHandlerPolicy.checkConnect((Object)saddr, fromID, this.getID(), target, (Object)data);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLeaveGroupMessage(ContainerMessage mess) {
        ID fromID = mess.getFromContainerID();
        if (fromID == null) {
            return;
        }
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            IAsynchConnection conn = this.getConnectionForID(fromID);
            if (conn == null) {
                return;
            }
            this.handleLeave(fromID, conn);
        }
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), fromID));
    }

    protected ID getIDForConnection(IAsynchConnection conn) {
        Object[] ms = this.groupManager.getMembers();
        int i = 0;
        while (i < ms.length) {
            Member m = (Member)ms[i];
            if (conn == (IAsynchConnection)m.getData()) {
                return m.getID();
            }
            ++i;
        }
        return null;
    }

    protected IAsynchConnection getConnectionForID(ID memberID) {
        Member mem = this.groupManager.getMemberForID(memberID);
        if (mem == null || !(mem.getData() instanceof IAsynchConnection)) {
            return null;
        }
        return (IAsynchConnection)mem.getData();
    }

    protected ISynchConnection getSynchConnectionForID(ID memberID) {
        Member mem = this.groupManager.getMemberForID(memberID);
        if (mem == null || !(mem.getData() instanceof ISynchConnection)) {
            return null;
        }
        return (ISynchConnection)mem.getData();
    }

    private final void queueToAll(ContainerMessage message) {
        Object[] members = this.groupManager.getMembers();
        int i = 0;
        while (i < members.length) {
            IAsynchConnection conn = (IAsynchConnection)((Member)members[i]).getData();
            if (conn != null) {
                try {
                    conn.sendAsynch(message.getToContainerID(), ServerSOContainer.serialize(message));
                }
                catch (IOException e) {
                    this.traceStack("Exception in queueToAll for ContainerMessage " + message, e);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDisconnect(DisconnectEvent e) {
        IAsynchConnection conn = (IAsynchConnection)e.getConnection();
        ID fromID = null;
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            fromID = this.getIDForConnection(conn);
            if (fromID == null) {
                return;
            }
            this.handleLeave(fromID, conn);
        }
        if (fromID != null) {
            this.fireContainerEvent((IContainerEvent)new ContainerEjectedEvent(this.getID(), fromID, (Serializable)e.getException()));
        }
    }
}

