/*
 * Decompiled with CFR 0.152.
 */
package com.mycorp.examples.timeservice.consumer;

import com.mycorp.examples.timeservice.ITimeService;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.DebugRemoteServiceAdminListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<ITimeService, ITimeService> {
    private BundleContext context;
    private ServiceTracker<ITimeService, ITimeService> timeServiceTracker;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        if (Boolean.getBoolean("verboseRemoteServiceAdmin")) {
            context.registerService(RemoteServiceAdminListener.class, (Object)new DebugRemoteServiceAdminListener(), null);
        }
        this.timeServiceTracker = new ServiceTracker(this.context, ITimeService.class, (ServiceTrackerCustomizer)this);
        this.timeServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.timeServiceTracker != null) {
            this.timeServiceTracker.close();
            this.timeServiceTracker = null;
        }
    }

    public ITimeService addingService(ServiceReference<ITimeService> reference) {
        System.out.println("ITimeService discovered!");
        System.out.println("Service Reference=" + reference);
        ITimeService timeService = (ITimeService)this.context.getService(reference);
        System.out.println("Calling timeService=" + timeService);
        Long time = timeService.getCurrentTime();
        System.out.println("Call Done.  Current time given by ITimeService.getCurrentTime() is: " + time);
        return timeService;
    }

    public void modifiedService(ServiceReference<ITimeService> reference, ITimeService service) {
    }

    public void removedService(ServiceReference<ITimeService> reference, ITimeService service) {
        System.out.println("ITimeService undiscovered!");
    }
}

