/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.util;

import ch.ethz.iks.r_osgi.types.BoxedPrimitive;
import ch.ethz.iks.util.SmartConstants;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class SmartObjectOutputStream
extends ObjectOutputStream {
    private final ObjectOutputStream out;

    public SmartObjectOutputStream(OutputStream out) throws IOException {
        this.out = new ObjectOutputStream(out);
    }

    @Override
    protected final void writeObjectOverride(Object o) throws IOException {
        if (o == null) {
            this.out.writeByte(0);
            return;
        }
        Object obj = o instanceof BoxedPrimitive ? ((BoxedPrimitive)o).getBoxed() : o;
        String clazzName = obj.getClass().getName();
        if (SmartConstants.positiveList.contains(clazzName)) {
            this.out.writeByte(1);
            String id = (String)SmartConstants.classToId.get(clazzName);
            this.out.writeUTF(id != null ? id : clazzName);
            this.out.writeUTF(obj.toString());
            return;
        }
        if (this.isNestedSmartSerializedObject(obj)) {
            Object[] objArray = (Object[])obj;
            String clazzname = objArray.getClass().getName();
            this.out.write(4);
            this.out.writeByte(objArray.length);
            this.out.writeUTF(clazzname.substring(2, clazzname.length() - 1));
            int i = 0;
            while (i < objArray.length) {
                Object elem = objArray[i];
                if (elem == null) {
                    this.out.writeByte(-1);
                } else {
                    this.writeSmartSerializedObject(elem);
                }
                ++i;
            }
        } else {
            if (obj instanceof Serializable) {
                this.out.writeByte(2);
                this.out.writeObject(obj);
                return;
            }
            this.writeSmartSerializedObject(obj);
        }
    }

    private boolean isNestedSmartSerializedObject(Object obj) {
        Object[] objArray;
        if (obj != null && obj instanceof Object[] && (objArray = (Object[])obj).length > 0) {
            int i = 0;
            while (i < objArray.length) {
                if (objArray[i] instanceof Serializable) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void writeSmartSerializedObject(Object obj) throws IOException, NotSerializableException {
        this.out.writeByte(3);
        Class<?> clazz = obj.getClass();
        if (SmartConstants.blackList.contains(clazz.getName())) {
            throw new NotSerializableException("Class " + clazz.getName() + " is not serializable");
        }
        this.out.writeUTF(clazz.getName());
        while (clazz != Object.class) {
            Method[] methods = clazz.getDeclaredMethods();
            int j = 0;
            while (j < methods.length) {
                int mod = methods[j].getModifiers();
                if (Modifier.isNative(mod)) {
                    throw new NotSerializableException("Class " + clazz.getName() + " contains native methods and is therefore not serializable.");
                }
                ++j;
            }
            try {
                int mod;
                Field[] fields = clazz.getDeclaredFields();
                int fieldCount = fields.length;
                int realFieldCount = 0;
                int i = 0;
                while (i < fieldCount) {
                    mod = fields[i].getModifiers();
                    if (!Modifier.isStatic(mod) && !Modifier.isTransient(mod)) {
                        ++realFieldCount;
                    }
                    ++i;
                }
                this.out.writeInt(realFieldCount);
                i = 0;
                while (i < fieldCount) {
                    mod = fields[i].getModifiers();
                    if (!Modifier.isStatic(mod) && !Modifier.isTransient(mod)) {
                        if (!Modifier.isPublic(mod)) {
                            fields[i].setAccessible(true);
                        }
                        this.out.writeUTF(fields[i].getName());
                        this.writeObjectOverride(fields[i].get(obj));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new NotSerializableException("Exception while serializing " + obj.toString() + ":\n" + e.getMessage());
            }
            clazz = clazz.getSuperclass();
        }
        this.out.writeInt(-1);
    }

    @Override
    public final void write(int val) throws IOException {
        this.out.write(val);
    }

    @Override
    public final void write(byte[] buf) throws IOException {
        this.out.write(buf);
    }

    @Override
    public final void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    @Override
    public final void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public final void reset() throws IOException {
        this.out.reset();
    }

    @Override
    public final void close() throws IOException {
        this.out.close();
    }

    @Override
    public final void writeBoolean(boolean val) throws IOException {
        this.out.writeBoolean(val);
    }

    @Override
    public final void writeByte(int val) throws IOException {
        this.out.writeByte(val);
    }

    @Override
    public final void writeShort(int val) throws IOException {
        this.out.writeShort(val);
    }

    @Override
    public final void writeChar(int val) throws IOException {
        this.out.writeChar(val);
    }

    @Override
    public final void writeInt(int val) throws IOException {
        this.out.writeInt(val);
    }

    @Override
    public final void writeLong(long val) throws IOException {
        this.out.writeLong(val);
    }

    @Override
    public final void writeFloat(float val) throws IOException {
        this.out.writeFloat(val);
    }

    @Override
    public final void writeDouble(double val) throws IOException {
        this.out.writeDouble(val);
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        this.out.writeBytes(str);
    }

    @Override
    public final void writeChars(String str) throws IOException {
        this.out.writeChars(str);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }
}

