/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.internal.example.collab.ClientPluginConstants;
import org.eclipse.ecf.internal.example.collab.ServerStartup;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ClientPlugin
extends AbstractUIPlugin
implements ClientPluginConstants {
    public static final String PLUGIN_ID = "org.eclipse.ecf.example.collab";
    public static final String COLLABORATION_IMAGE = "collaboration";
    private static ClientPlugin plugin;
    private FontRegistry fontRegistry = null;
    private ServerStartup serverStartup = null;
    private BundleContext context;

    public static void log(String message) {
        ClientPlugin.getDefault().getLog().log((IStatus)new Status(0, ClientPlugin.getDefault().getBundle().getSymbolicName(), 0, message, null));
    }

    public static void log(String message, Throwable e) {
        ClientPlugin.getDefault().getLog().log((IStatus)new Status(4, ClientPlugin.getDefault().getBundle().getSymbolicName(), 0, message, e));
    }

    public ClientPlugin() {
        plugin = this;
        this.fontRegistry = new FontRegistry();
    }

    protected void setPreferenceDefaults() {
        this.getPreferenceStore().setDefault("useChatWindow", false);
        this.getPreferenceStore().setDefault("displayTimeStamp", true);
        this.getPreferenceStore().setDefault("confirmFileSend", true);
        this.getPreferenceStore().setDefault("confirmRemoteView", true);
        this.getPreferenceStore().setDefault("startServerOnStartup", false);
        this.getPreferenceStore().setDefault("registerServerOnStartup", false);
        this.getPreferenceStore().setDefault("sharedEditorShowEvents", true);
        this.getPreferenceStore().setDefault("sharedEditorAskReceiver", true);
    }

    public void start(BundleContext ctxt) throws Exception {
        super.start(ctxt);
        this.setPreferenceDefaults();
        this.context = ctxt;
    }

    protected BundleContext getContext() {
        return this.context;
    }

    public synchronized void initServer() throws Exception {
        if (this.serverStartup == null) {
            this.serverStartup = new ServerStartup();
        }
    }

    public synchronized boolean isServerActive() {
        if (this.serverStartup == null) {
            return false;
        }
        return this.serverStartup.isActive();
    }

    public synchronized void disposeServer() {
        if (this.serverStartup != null) {
            this.serverStartup.dispose();
            this.serverStartup = null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        context = null;
        this.disposeServer();
    }

    public FontRegistry getFontRegistry() {
        return this.fontRegistry;
    }

    public Shell getActiveShell() {
        return this.getWorkbench().getDisplay().getActiveShell();
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        registry.put(COLLABORATION_IMAGE, AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/collaboration.gif"));
    }

    public static ClientPlugin getDefault() {
        return plugin;
    }
}

