/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.Hashtable;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.packet.DefaultPrivateData;
import org.jivesoftware.smackx.packet.PrivateData;
import org.jivesoftware.smackx.provider.PrivateDataProvider;
import org.xmlpull.v1.XmlPullParser;

public class PrivateDataManager {
    private static Map<String, PrivateDataProvider> privateDataProviders = new Hashtable<String, PrivateDataProvider>();
    private Connection connection;
    private String user;

    public static PrivateDataProvider getPrivateDataProvider(String elementName, String namespace) {
        String key = PrivateDataManager.getProviderKey(elementName, namespace);
        return privateDataProviders.get(key);
    }

    public static void addPrivateDataProvider(String elementName, String namespace, PrivateDataProvider provider) {
        String key = PrivateDataManager.getProviderKey(elementName, namespace);
        privateDataProviders.put(key, provider);
    }

    public static void removePrivateDataProvider(String elementName, String namespace) {
        String key = PrivateDataManager.getProviderKey(elementName, namespace);
        privateDataProviders.remove(key);
    }

    public PrivateDataManager(Connection connection) {
        if (!connection.isAuthenticated()) {
            throw new IllegalStateException("Must be logged in to XMPP server.");
        }
        this.connection = connection;
    }

    public PrivateDataManager(Connection connection, String user) {
        if (!connection.isAuthenticated()) {
            throw new IllegalStateException("Must be logged in to XMPP server.");
        }
        this.connection = connection;
        this.user = user;
    }

    public PrivateData getPrivateData(final String elementName, final String namespace) throws XMPPException {
        IQ privateDataGet = new IQ(){

            public String getChildElementXML() {
                StringBuilder buf = new StringBuilder();
                buf.append("<query xmlns=\"jabber:iq:private\">");
                buf.append("<").append(elementName).append(" xmlns=\"").append(namespace).append("\"/>");
                buf.append("</query>");
                return buf.toString();
            }
        };
        privateDataGet.setType(IQ.Type.GET);
        if (this.user != null) {
            privateDataGet.setTo(this.user);
        }
        String packetID = privateDataGet.getPacketID();
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(packetID));
        this.connection.sendPacket(privateDataGet);
        IQ response = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from the server.");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException(response.getError());
        }
        return ((PrivateDataResult)response).getPrivateData();
    }

    public void setPrivateData(final PrivateData privateData) throws XMPPException {
        IQ privateDataSet = new IQ(){

            public String getChildElementXML() {
                StringBuilder buf = new StringBuilder();
                buf.append("<query xmlns=\"jabber:iq:private\">");
                buf.append(privateData.toXML());
                buf.append("</query>");
                return buf.toString();
            }
        };
        privateDataSet.setType(IQ.Type.SET);
        if (this.user != null) {
            privateDataSet.setTo(this.user);
        }
        String packetID = privateDataSet.getPacketID();
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(packetID));
        this.connection.sendPacket(privateDataSet);
        IQ response = (IQ)collector.nextResult(5000L);
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from the server.");
        }
        if (response.getType() == IQ.Type.ERROR) {
            throw new XMPPException(response.getError());
        }
    }

    private static String getProviderKey(String elementName, String namespace) {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(elementName).append("/><").append(namespace).append("/>");
        return buf.toString();
    }

    public static class PrivateDataIQProvider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            PrivateData privateData = null;
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    String namespace;
                    String elementName = parser.getName();
                    PrivateDataProvider provider = PrivateDataManager.getPrivateDataProvider(elementName, namespace = parser.getNamespace());
                    if (provider != null) {
                        privateData = provider.parsePrivateData(parser);
                        continue;
                    }
                    DefaultPrivateData data = new DefaultPrivateData(elementName, namespace);
                    boolean finished = false;
                    while (!finished) {
                        int event = parser.next();
                        if (event == 2) {
                            String name = parser.getName();
                            if (parser.isEmptyElementTag()) {
                                data.setValue(name, "");
                                continue;
                            }
                            event = parser.next();
                            if (event != 4) continue;
                            String value = parser.getText();
                            data.setValue(name, value);
                            continue;
                        }
                        if (event != 3 || !parser.getName().equals(elementName)) continue;
                        finished = true;
                    }
                    privateData = data;
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("query")) continue;
                done = true;
            }
            return new PrivateDataResult(privateData);
        }
    }

    private static class PrivateDataResult
    extends IQ {
        private PrivateData privateData;

        PrivateDataResult(PrivateData privateData) {
            this.privateData = privateData;
        }

        public PrivateData getPrivateData() {
            return this.privateData;
        }

        public String getChildElementXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<query xmlns=\"jabber:iq:private\">");
            if (this.privateData != null) {
                this.privateData.toXML();
            }
            buf.append("</query>");
            return buf.toString();
        }
    }
}

