/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DataForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form {
    public static final String TYPE_FORM = "form";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_CANCEL = "cancel";
    public static final String TYPE_RESULT = "result";
    public static final String NAMESPACE = "jabber:x:data";
    public static final String ELEMENT = "x";
    private DataForm dataForm;

    public static Form getFormFrom(Packet packet) {
        DataForm dataForm;
        PacketExtension packetExtension = packet.getExtension(ELEMENT, NAMESPACE);
        if (packetExtension != null && (dataForm = (DataForm)packetExtension).getReportedData() == null) {
            return new Form(dataForm);
        }
        return null;
    }

    public Form(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public Form(String type) {
        this.dataForm = new DataForm(type);
    }

    public void addField(FormField field) {
        this.dataForm.addField(field);
    }

    public void setAnswer(String variable, String value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!("text-multi".equals(field.getType()) || "text-private".equals(field.getType()) || "text-single".equals(field.getType()) || "jid-single".equals(field.getType()) || "hidden".equals(field.getType()))) {
            throw new IllegalArgumentException("This field is not of type String.");
        }
        this.setAnswer(field, (Object)value);
    }

    public void setAnswer(String variable, int value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!("text-multi".equals(field.getType()) || "text-private".equals(field.getType()) || "text-single".equals(field.getType()))) {
            throw new IllegalArgumentException("This field is not of type int.");
        }
        this.setAnswer(field, (Object)value);
    }

    public void setAnswer(String variable, long value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!("text-multi".equals(field.getType()) || "text-private".equals(field.getType()) || "text-single".equals(field.getType()))) {
            throw new IllegalArgumentException("This field is not of type long.");
        }
        this.setAnswer(field, (Object)value);
    }

    public void setAnswer(String variable, float value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!("text-multi".equals(field.getType()) || "text-private".equals(field.getType()) || "text-single".equals(field.getType()))) {
            throw new IllegalArgumentException("This field is not of type float.");
        }
        this.setAnswer(field, Float.valueOf(value));
    }

    public void setAnswer(String variable, double value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!("text-multi".equals(field.getType()) || "text-private".equals(field.getType()) || "text-single".equals(field.getType()))) {
            throw new IllegalArgumentException("This field is not of type double.");
        }
        this.setAnswer(field, (Object)value);
    }

    public void setAnswer(String variable, boolean value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!"boolean".equals(field.getType())) {
            throw new IllegalArgumentException("This field is not of type boolean.");
        }
        this.setAnswer(field, (Object)(value ? "1" : "0"));
    }

    private void setAnswer(FormField field, Object value) {
        if (!this.isSubmitType()) {
            throw new IllegalStateException("Cannot set an answer if the form is not of type \"submit\"");
        }
        field.resetValues();
        field.addValue(value.toString());
    }

    public void setAnswer(String variable, List<String> values) {
        if (!this.isSubmitType()) {
            throw new IllegalStateException("Cannot set an answer if the form is not of type \"submit\"");
        }
        FormField field = this.getField(variable);
        if (field != null) {
            if (!("jid-multi".equals(field.getType()) || "list-multi".equals(field.getType()) || "list-single".equals(field.getType()) || "text-multi".equals(field.getType()) || "hidden".equals(field.getType()))) {
                throw new IllegalArgumentException("This field only accept list of values.");
            }
        } else {
            throw new IllegalArgumentException("Couldn't find a field for the specified variable.");
        }
        field.resetValues();
        field.addValues(values);
    }

    public void setDefaultAnswer(String variable) {
        if (!this.isSubmitType()) {
            throw new IllegalStateException("Cannot set an answer if the form is not of type \"submit\"");
        }
        FormField field = this.getField(variable);
        if (field != null) {
            field.resetValues();
            Iterator<String> it = field.getValues();
            while (it.hasNext()) {
                field.addValue(it.next());
            }
        } else {
            throw new IllegalArgumentException("Couldn't find a field for the specified variable.");
        }
    }

    public Iterator<FormField> getFields() {
        return this.dataForm.getFields();
    }

    public FormField getField(String variable) {
        if (variable == null || variable.equals("")) {
            throw new IllegalArgumentException("Variable must not be null or blank.");
        }
        Iterator<FormField> it = this.getFields();
        while (it.hasNext()) {
            FormField field = it.next();
            if (!variable.equals(field.getVariable())) continue;
            return field;
        }
        return null;
    }

    public String getInstructions() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = this.dataForm.getInstructions();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getTitle() {
        return this.dataForm.getTitle();
    }

    public String getType() {
        return this.dataForm.getType();
    }

    public void setInstructions(String instructions) {
        ArrayList<String> instructionsList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(instructions, "\n");
        while (st.hasMoreTokens()) {
            instructionsList.add(st.nextToken());
        }
        this.dataForm.setInstructions(instructionsList);
    }

    public void setTitle(String title) {
        this.dataForm.setTitle(title);
    }

    public DataForm getDataFormToSend() {
        if (this.isSubmitType()) {
            DataForm dataFormToSend = new DataForm(this.getType());
            Iterator<FormField> it = this.getFields();
            while (it.hasNext()) {
                FormField field = it.next();
                if (!field.getValues().hasNext()) continue;
                dataFormToSend.addField(field);
            }
            return dataFormToSend;
        }
        return this.dataForm;
    }

    private boolean isFormType() {
        return TYPE_FORM.equals(this.dataForm.getType());
    }

    private boolean isSubmitType() {
        return TYPE_SUBMIT.equals(this.dataForm.getType());
    }

    public Form createAnswerForm() {
        if (!this.isFormType()) {
            throw new IllegalStateException("Only forms of type \"form\" could be answered");
        }
        Form form = new Form(TYPE_SUBMIT);
        Iterator<FormField> fields = this.getFields();
        while (fields.hasNext()) {
            FormField field = fields.next();
            if (field.getVariable() == null) continue;
            FormField newField = new FormField(field.getVariable());
            newField.setType(field.getType());
            form.addField(newField);
            if (!"hidden".equals(field.getType())) continue;
            ArrayList<String> values = new ArrayList<String>();
            Iterator<String> it = field.getValues();
            while (it.hasNext()) {
                values.add(it.next());
            }
            form.setAnswer(field.getVariable(), values);
        }
        return form;
    }
}

