/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.util;

import ch.ethz.iks.util.ScheduleListener;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class Scheduler {
    final SortedMap expirationQueue = new TreeMap();
    private final Map expirationDataIndex = new HashMap(0);
    final ScheduleListener listener;
    private final ScheduleThread thread;
    boolean running;

    public Scheduler(ScheduleListener listener) {
        this.listener = listener;
        this.thread = new ScheduleThread();
        this.start();
    }

    public void start() {
        this.running = true;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        SortedMap sortedMap = this.expirationQueue;
        synchronized (sortedMap) {
            this.expirationQueue.clear();
            this.expirationDataIndex.clear();
            this.expirationQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScheduled(Object object) {
        SortedMap sortedMap = this.expirationQueue;
        synchronized (sortedMap) {
            Long scheduled = (Long)this.expirationDataIndex.get(object);
            return scheduled != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Object object, long timestamp) throws IllegalStateException {
        SortedMap sortedMap = this.expirationQueue;
        synchronized (sortedMap) {
            if (this.isScheduled(object)) {
                throw new IllegalStateException("Object " + object + " is already scheduled.");
            }
            Long ts = new Long(timestamp);
            this.expirationQueue.put(ts, object);
            this.expirationDataIndex.put(object, ts);
            this.expirationQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule(Object object, long newTimestamp) {
        SortedMap sortedMap = this.expirationQueue;
        synchronized (sortedMap) {
            this.unschedule(object);
            this.schedule(object, newTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unschedule(Object object) {
        SortedMap sortedMap = this.expirationQueue;
        synchronized (sortedMap) {
            Long scheduled = (Long)this.expirationDataIndex.remove(object);
            this.expirationQueue.remove(scheduled);
        }
    }

    private class ScheduleThread
    extends Thread {
        ScheduleThread() {
            this.setDaemon(true);
            this.setName("Scheduler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
lbl1:
            // 2 sources

            try {
                while (Scheduler.this.running) {
                    var1_1 = Scheduler.this.expirationQueue;
                    synchronized (var1_1) {
                        if (!Scheduler.this.expirationQueue.isEmpty()) ** GOTO lbl11
                        Scheduler.this.expirationQueue.wait();
                        ** GOTO lbl1
lbl-1000:
                        // 1 sources

                        {
                            object = Scheduler.this.expirationQueue.remove(nextActivity);
                            Scheduler.this.listener.due(Scheduler.this, nextActivity, object);
lbl11:
                            // 2 sources

                            ** while (!Scheduler.this.expirationQueue.isEmpty() && (nextActivity = (Long)Scheduler.this.expirationQueue.firstKey()).longValue() <= System.currentTimeMillis() + 10L)
                        }
lbl12:
                        // 1 sources

                        if (!Scheduler.this.expirationQueue.isEmpty() && (next = (nextActivity = (Long)Scheduler.this.expirationQueue.firstKey()) - System.currentTimeMillis() - 10L) > 0L) {
                            Scheduler.this.expirationQueue.wait(next);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

