/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.storage;

import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.internal.storage.Activator;
import org.eclipse.ecf.storage.IDStoreException;
import org.eclipse.ecf.storage.IIDEntry;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;

public class IDEntry
implements IIDEntry {
    private static final String DELIMITER = ":";
    private final ISecurePreferences prefs;

    public IDEntry(ISecurePreferences prefs) {
        this.prefs = prefs;
    }

    public ISecurePreferences getPreferences() {
        return this.prefs;
    }

    public void putAssociate(String key, IIDEntry entry, boolean encrypt) throws IDStoreException {
        if (key == null) {
            throw new IDStoreException("key cannot be null");
        }
        if (entry == null) {
            throw new IDStoreException("entry cannot be null");
        }
        ISecurePreferences associateNode = this.prefs.node(key);
        ISecurePreferences prefs = entry.getPreferences();
        String entryAssociate = String.valueOf(String.valueOf(associateNode.childrenNames().length)) + DELIMITER + prefs.parent().name() + DELIMITER + prefs.name();
        associateNode.node(entryAssociate);
    }

    private ISecurePreferences getNamespaceRoot() {
        return this.prefs.parent().parent();
    }

    private ISecurePreferences getPreferences(ISecurePreferences parent, String name) {
        List<String> names = Arrays.asList(parent.childrenNames());
        if (names.contains(name)) {
            return parent.node(name);
        }
        return null;
    }

    private void addAssociateFromName(String name, SortedMap results) {
        try {
            int index = name.indexOf(DELIMITER);
            if (index == -1) {
                throw new IDStoreException("Associate ID not well-formed");
            }
            String indexStr = name.substring(0, index);
            Integer resultIndex = null;
            try {
                resultIndex = Integer.valueOf(indexStr);
            }
            catch (NumberFormatException e) {
                throw new IDStoreException("Associate ID not well-formed", e);
            }
            name = name.substring(index + 1);
            index = name.indexOf(DELIMITER);
            if (index == -1) {
                throw new IDStoreException("Associate ID not well-formed");
            }
            String namespaceName = name.substring(0, index);
            ISecurePreferences namespacePrefs = this.getPreferences(this.getNamespaceRoot(), namespaceName);
            if (namespacePrefs == null) {
                throw new IDStoreException("Cannot find Namespace=" + namespaceName);
            }
            String idName = name.substring(index + 1);
            ISecurePreferences idPrefs = this.getPreferences(namespacePrefs, idName);
            if (idPrefs == null) {
                throw new IDStoreException("ID=" + idName + " not found in Namespace=" + namespaceName);
            }
            results.put(resultIndex, new IDEntry(idPrefs));
        }
        catch (IDStoreException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.storage", 4, "Unable to create associate ID", (Throwable)((Object)e)));
        }
    }

    public ID createID() throws IDCreateException {
        return IDFactory.getDefault().createID(this.prefs.parent().name(), EncodingUtils.decodeSlashes((String)this.prefs.name()));
    }

    public void delete() {
        this.prefs.removeNode();
    }

    public IIDEntry[] getAssociates(String key) {
        if (key == null) {
            return new IIDEntry[0];
        }
        ISecurePreferences associateNode = this.prefs.node(key);
        String[] childrenNames = associateNode.childrenNames();
        TreeMap results = new TreeMap();
        int i = 0;
        while (i < childrenNames.length) {
            this.addAssociateFromName(childrenNames[i], results);
            ++i;
        }
        return results.values().toArray(new IIDEntry[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("IDEntry[");
        sb.append(this.prefs.name()).append("]");
        return sb.toString();
    }
}

