/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.core.variants;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ecf.core.TeamSynchronization;
import org.eclipse.team.internal.ecf.core.variants.RemoteStorage;

public class RemoteResourceVariant
implements IResourceVariant,
Serializable {
    private static final long serialVersionUID = 2103652156613434181L;
    private final String name;
    private final String path;
    private final int type;
    private final long timeStamp;
    private final boolean hasMembers;
    private byte[] bytes;
    private IStorage storage;

    public RemoteResourceVariant(IResource resource) {
        this.name = resource.getName();
        this.path = resource.getFullPath().toString();
        this.type = resource.getType();
        this.timeStamp = resource.getLocalTimeStamp();
        Assert.isLegal((this.type == 1 || this.type == 2 || this.type == 4 ? 1 : 0) != 0, (String)("Invalid resource type specified: " + this.type));
        if (this.type == 1) {
            this.hasMembers = false;
            IFile file = (IFile)resource;
            this.bytes = TeamSynchronization.readFile(file);
            if (this.bytes != null) {
                try {
                    this.storage = new RemoteStorage(this.path, file.getCharset(), this.bytes);
                }
                catch (CoreException e) {
                    TeamSynchronization.log("Could not retrieve file charset", e);
                }
            }
        } else {
            boolean temp;
            block10: {
                temp = false;
                try {
                    if (!resource.exists()) break block10;
                    IResource[] members = ((IContainer)resource).members();
                    int i = 0;
                    while (i < members.length) {
                        if (!members[i].isDerived()) {
                            temp = true;
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            this.hasMembers = temp;
        }
        if (this.bytes == null) {
            this.bytes = this.getContentIdentifier().getBytes();
        }
    }

    public byte[] asBytes() {
        return this.bytes;
    }

    public String getContentIdentifier() {
        return new Date(this.timeStamp).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public IStorage getStorage(IProgressMonitor monitor) {
        return this.storage;
    }

    public boolean isContainer() {
        return this.type != 1;
    }

    public boolean hasMembers() {
        return this.hasMembers;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return this.path;
    }
}

