/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.presence.bot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ecf.internal.presence.bot.ChatRoomBotEntry;
import org.eclipse.ecf.internal.presence.bot.ChatRoomMessageHandlerEntry;
import org.eclipse.ecf.internal.presence.bot.IMBotEntry;
import org.eclipse.ecf.internal.presence.bot.IMMessageHandlerEntry;
import org.eclipse.ecf.presence.bot.IChatRoomMessageHandler;
import org.eclipse.ecf.presence.bot.IIMMessageHandler;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final String CHATROOMPASSWORD_ATT = "password";
    private static final String CHATROOMNAME_ATT = "name";
    private static final String CHATROOM_ELEMENT = "chatRooms";
    private static final String PASSWORD_ATT = "connectPassword";
    private static final String CONNECT_ID_ATT = "connectId";
    private static final String CONTAINER_FACTORY_NAME_ATT = "containerFactoryName";
    private static final String NAME_ATT = "name";
    private static final String ID_ATT = "id";
    private static final String CLASS_ATT = "class";
    private static final String FILTEREXPRESSION_ATT = "filterExpression";
    private static final String CHATROOMROBOTID_ATT = "chatRoomRobotId";
    private static final String IMROBOTID_ATT = "imRobotId";
    public static final String PLUGIN_ID = "org.eclipse.ecf.presence.bot";
    public static final String CHATROOM_COMMAND_HANDLER_EPOINT_NAME = "chatRoomMessageHandler";
    public static final String CHATROOM_COMMAND_HANDLER_EPOINT = "org.eclipse.ecf.presence.bot.chatRoomMessageHandler";
    public static final String IM_COMMAND_HANDLER_EPOINT_NAME = "imMessageHandler";
    public static final String IM_COMMAND_HANDLER_EPOINT = "org.eclipse.ecf.presence.bot.imMessageHandler";
    public static final String CHATROOM_BOT_EPOINT_NAME = "chatRoomRobot";
    public static final String CHATROOM_BOT_EPOINT = "org.eclipse.ecf.presence.bot.chatRoomRobot";
    public static final String IM_BOT_EPOINT_NAME = "imRobot";
    public static final String IM_BOT_EPOINT = "org.eclipse.ecf.presence.bot.imRobot";
    private static Activator plugin;
    private BundleContext context = null;
    private ServiceTracker extensionRegistryTracker = null;
    private Map chatroombots = new HashMap();
    private Map chatbotcommands = new HashMap();
    private Map imbots = new HashMap();
    private Map imbotcommands = new HashMap();
    static /* synthetic */ Class class$0;

    public IExtensionRegistry getExtensionRegistry() {
        if (this.extensionRegistryTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.extensionRegistryTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.extensionRegistryTracker.open();
        }
        return (IExtensionRegistry)this.extensionRegistryTracker.getService();
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        this.context = context;
        this.loadChatBotExtensions();
        this.loadIMBotExtensions();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.extensionRegistryTracker != null) {
            this.extensionRegistryTracker.close();
            this.extensionRegistryTracker = null;
        }
        plugin = null;
        this.context = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    public Map getChatRoomBots() {
        return this.chatroombots;
    }

    public Map getIMBots() {
        return this.imbots;
    }

    private void loadChatBotExtensions() throws CoreException {
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            String id;
            IConfigurationElement[] elements = reg.getConfigurationElementsFor(CHATROOM_COMMAND_HANDLER_EPOINT);
            int i = 0;
            while (i < elements.length) {
                id = elements[i].getAttribute(CHATROOMROBOTID_ATT);
                String expression = elements[i].getAttribute(FILTEREXPRESSION_ATT);
                IChatRoomMessageHandler handler = (IChatRoomMessageHandler)elements[i].createExecutableExtension(CLASS_ATT);
                ArrayList<ChatRoomMessageHandlerEntry> c = (ArrayList<ChatRoomMessageHandlerEntry>)this.chatbotcommands.get(id);
                if (c == null) {
                    c = new ArrayList<ChatRoomMessageHandlerEntry>();
                    c.add(new ChatRoomMessageHandlerEntry(expression, handler));
                    this.chatbotcommands.put(id, c);
                } else {
                    c.add(new ChatRoomMessageHandlerEntry(expression, handler));
                    this.chatbotcommands.put(id, c);
                }
                ++i;
            }
            elements = reg.getConfigurationElementsFor(CHATROOM_BOT_EPOINT);
            i = 0;
            while (i < elements.length) {
                id = elements[i].getAttribute(ID_ATT);
                String name = elements[i].getAttribute("name");
                String containerFactoryName = elements[i].getAttribute(CONTAINER_FACTORY_NAME_ATT);
                String connectID = elements[i].getAttribute(CONNECT_ID_ATT);
                String password = elements[i].getAttribute(PASSWORD_ATT);
                IConfigurationElement[] chatRoomElements = elements[i].getChildren(CHATROOM_ELEMENT);
                int length = chatRoomElements.length;
                String[] chatRoomNames = new String[length];
                String[] chatRoomPasswords = new String[length];
                int j = 0;
                while (j < chatRoomElements.length) {
                    chatRoomNames[j] = chatRoomElements[j].getAttribute("name");
                    chatRoomPasswords[j] = chatRoomElements[j].getAttribute(CHATROOMPASSWORD_ATT);
                    ++j;
                }
                ArrayList c = (ArrayList)this.chatbotcommands.get(id);
                if (c == null) {
                    c = new ArrayList();
                }
                ChatRoomBotEntry bot = new ChatRoomBotEntry(id, name, containerFactoryName, connectID, password, chatRoomNames, chatRoomPasswords, c);
                this.chatroombots.put(id, bot);
                ++i;
            }
        }
    }

    private void loadIMBotExtensions() throws CoreException {
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            String id;
            IConfigurationElement[] elements = reg.getConfigurationElementsFor(IM_COMMAND_HANDLER_EPOINT);
            int i = 0;
            while (i < elements.length) {
                id = elements[i].getAttribute(IMROBOTID_ATT);
                String expression = elements[i].getAttribute(FILTEREXPRESSION_ATT);
                IIMMessageHandler handler = (IIMMessageHandler)elements[i].createExecutableExtension(CLASS_ATT);
                ArrayList<IMMessageHandlerEntry> c = (ArrayList<IMMessageHandlerEntry>)this.imbotcommands.get(id);
                if (c == null) {
                    c = new ArrayList<IMMessageHandlerEntry>();
                    c.add(new IMMessageHandlerEntry(expression, handler));
                    this.imbotcommands.put(id, c);
                } else {
                    c.add(new IMMessageHandlerEntry(expression, handler));
                    this.imbotcommands.put(id, c);
                }
                ++i;
            }
            elements = reg.getConfigurationElementsFor(IM_BOT_EPOINT);
            i = 0;
            while (i < elements.length) {
                id = elements[i].getAttribute(ID_ATT);
                String name = elements[i].getAttribute("name");
                String containerFactoryName = elements[i].getAttribute(CONTAINER_FACTORY_NAME_ATT);
                String connectID = elements[i].getAttribute(CONNECT_ID_ATT);
                String password = elements[i].getAttribute(PASSWORD_ATT);
                ArrayList c = (ArrayList)this.imbotcommands.get(id);
                if (c == null) {
                    c = new ArrayList();
                }
                IMBotEntry bot = new IMBotEntry(id, name, containerFactoryName, connectID, password, c);
                this.imbots.put(id, bot);
                ++i;
            }
        }
    }
}

