/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.util;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.provider.zookeeper.core.internal.Configurator;

public class Geo {
    public static boolean isLocal(String path) {
        Assert.isNotNull((Object)path);
        Assert.isTrue((path.length() > "/zoodiscovery_root".length() ? 1 : 0) != 0);
        String[] parts = path.split("_uri_");
        String host = parts[1];
        return Geo.getHost().equals(host);
    }

    public static boolean isOwnPublication(String childPath) {
        Assert.isNotNull((Object)childPath);
        Assert.isTrue((childPath.length() > "/zoodiscovery_root".length() ? 1 : 0) != 0);
        String[] parts = childPath.split("_zdid_");
        String id = parts[1];
        return id.equals(Configurator.INSTANCE.getID().getName());
    }

    public static URI getLocation() {
        try {
            return URI.create(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getHost() {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        return host;
    }

    public static String getNodeHost() {
        String host;
        try {
            host = InetAddress.getLocalHost().toString();
            host = host.replace("/", "-");
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        return host;
    }
}

