/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.editors;

import java.io.IOException;
import java.util.EventObject;
import java.util.Iterator;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.configuration.EditingDomainUtils;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ReqCycleEditor
extends EcoreEditor {
    public static final String LOCAL_CONNECTOR_ID = "org.polarsys.reqcycle.repository.connector.local.connectorCore";
    public static final String EDITOR_ID = "org.polarsys.reqcycle.repository.data.ui.editor";
    protected URI inputURI;
    @Inject
    ILogger logger;
    @Inject
    IDataManager dataManager;
    @Inject
    IDataModelManager dataModelManager;
    @Inject
    IConfigurationManager confManager;
    AdapterFactoryEditingDomain.EditingDomainProvider editingDomainAdapter;

    public static void openEditor(URI uri) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            URIEditorInput editorInput = new URIEditorInput(uri);
            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)EDITOR_ID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected boolean handleDirtyConflict() {
        return false;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            this.dataManager.save();
            ((BasicCommandStack)this.editingDomain.getCommandStack()).flush();
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)e.getMessage(), (IStatus)new Status(4, "org.polarsys.reqcycle.repository.data.ui", e.getMessage(), (Throwable)e));
            e.printStackTrace();
        }
    }

    protected void updateProblemIndication() {
    }

    protected void initializeEditorInput() {
        this.inputURI = null;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof URIEditorInput) {
            this.inputURI = ((URIEditorInput)editorInput).getURI();
        }
    }

    protected void setActivePage(int pageIndex) {
        super.setActivePage(0);
    }

    protected void initializeEditingDomain() {
        ZigguratInject.inject((Object[])new Object[]{this});
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        ResourceSet configurationResourceSet = this.confManager.getConfigurationResourceSet();
        this.editingDomain = EditingDomainUtils.getOrCreateEditingDomain((ResourceSet)configurationResourceSet);
        CommandStack commandStack = this.editingDomain.getCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ReqCycleEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            ReqCycleEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator i = ReqCycleEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = (PropertySheetPage)i.next();
                            if (propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
    }

    public void createPages() {
        this.initializeEditorInput();
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    Tree tree = new Tree(composite, 0);
                    TreeViewer newTreeViewer = new TreeViewer(tree);
                    return newTreeViewer;
                }

                public void requestActivation() {
                    super.requestActivation();
                }

                protected void createTitleBar() {
                    this.titleLabel = new CLabel((Composite)this.control, 32);
                    super.createTitleBar();
                }
            };
            viewerPane.createControl(this.getContainer());
            this.selectionViewer = (TreeViewer)viewerPane.getViewer();
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setInput(this.getInput());
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage(viewerPane.getControl());
            this.setPageText(pageIndex, this.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReqCycleEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    ReqCycleEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ReqCycleEditor.this.updateProblemIndication();
            }
        });
    }

    protected ViewerFilter[] createViewerFilters() {
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof RequirementSource) {
                    if (ReqCycleEditor.LOCAL_CONNECTOR_ID.equals(((RequirementSource)element).getConnectorId())) {
                        if (ReqCycleEditor.this.inputURI != null && ReqCycleEditor.this.inputURI.hasFragment()) {
                            return ReqCycleEditor.this.inputURI.fragment().equals(((RequirementSource)element).eResource().getURIFragment((EObject)((RequirementSource)element)));
                        }
                        return true;
                    }
                    return false;
                }
                return true;
            }
        };
        return new ViewerFilter[]{viewerFilter};
    }

    protected Object getInput() {
        if (this.inputURI != null) {
            return this.editingDomain.getResourceSet().getResource(this.inputURI.trimFragment(), true);
        }
        return this.editingDomain.getResourceSet().getResources();
    }

    protected String getString(String key) {
        return EcoreEditorPlugin.INSTANCE.getString(key);
    }

    protected void setPartName(String partName) {
        super.setPartName("Requirements Editor");
    }

    public void dispose() {
        this.confManager.getConfigurationResourceSet().eAdapters().remove((Object)this.editingDomainAdapter);
        super.dispose();
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (this.inputURI != null && resource != null && this.inputURI.trimFragment().equals(resource.getURI())) {
            return super.analyzeResourceProblems(resource, exception);
        }
        return Diagnostic.OK_INSTANCE;
    }
}

