/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.rmf;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingAttribute;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.internal.RequirementTypeImpl;
import org.polarsys.reqcycle.repository.data.util.DataUtil;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class RMFUtils {
    static ILogger logger = (ILogger)ZigguratInject.make(ILogger.class);
    static IDataModelManager dataTypeManager = (IDataModelManager)ZigguratInject.make(IDataModelManager.class);
    static IDataManager dataManager = (IDataManager)ZigguratInject.make(IDataManager.class);
    public static final String SPECIFICATION_ID = "SpecificationId";
    public static final String SPECIFICATION_NAME = "SpecificationName";
    public static ITreeContentProvider contentProvider = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return ArrayContentProvider.getInstance().getElements(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }
    };

    public static Collection<SpecType> getReqIFTypes(ResourceSet resourceSet, String fileLocation) {
        EObject content;
        URI uriReqIf = URI.createURI((String)fileLocation, (boolean)false);
        Resource reqIfResource = resourceSet.getResource(uriReqIf, true);
        EList contents = reqIfResource.getContents();
        if (contents.size() > 0 && (content = (EObject)contents.get(0)) instanceof ReqIF) {
            ReqIFContent coreContent = ((ReqIF)content).getCoreContent();
            EList specTypes = coreContent.getSpecTypes();
            return Collections2.filter((Collection)specTypes, (Predicate)new Predicate<SpecType>(){

                public boolean apply(SpecType arg0) {
                    return arg0 instanceof SpecObjectType;
                }
            });
        }
        return null;
    }

    public static Collection<Specification> getReqIFDocuments(ResourceSet resourceSet, String fileLocation) {
        EObject content;
        URI uriReqIf = URI.createURI((String)fileLocation, (boolean)false);
        Resource reqIfResource = resourceSet.getResource(uriReqIf, true);
        EList contents = reqIfResource.getContents();
        if (contents.size() > 0 && (content = (EObject)contents.get(0)) instanceof ReqIF) {
            ReqIFContent coreContent = ((ReqIF)content).getCoreContent();
            return coreContent.getSpecifications();
        }
        return null;
    }

    public static void fillRequirements(RequirementSource requirementSource, IProgressMonitor progressMonitor, Scope scope) {
        EList mapping = requirementSource.getMappings();
        if (mapping == null) {
            return;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createURI((String)requirementSource.getRepositoryURI(), (boolean)false), true);
        EList contents = resource.getContents();
        for (EObject eObject : contents) {
            ReqIF reqIF;
            Specification specification;
            EList specHierarchies;
            Collection<AbstractElement> children;
            if (!(eObject instanceof ReqIF) || (children = RMFUtils.createChildren((EList<SpecHierarchy>)(specHierarchies = (specification = RMFUtils.getSpecification(reqIF = (ReqIF)eObject, requirementSource.getProperty(SPECIFICATION_ID), requirementSource.getProperty(SPECIFICATION_NAME))).getChildren()), (Collection<MappingElement>)mapping, scope)) == null || children.isEmpty()) continue;
            dataManager.addElementsToSource(requirementSource, children.toArray(new AbstractElement[children.size()]));
        }
    }

    protected static Specification getSpecification(ReqIF reqif, String specificationId, String specificationName) {
        EList specifications = reqif.getCoreContent().getSpecifications();
        Specification specificationByName = null;
        for (Specification specification : specifications) {
            if (specificationId.equals(specification.getIdentifier())) {
                return specification;
            }
            if (!specificationName.equals(specification.getLongName())) continue;
            specificationByName = specification;
        }
        return specificationByName;
    }

    protected static Collection<AbstractElement> createChildren(EList<SpecHierarchy> specHierarchies, Collection<MappingElement> mapping, Scope scope) {
        ArrayList<AbstractElement> result = new ArrayList<AbstractElement>();
        for (SpecHierarchy specHierarchy : specHierarchies) {
            Collection<AbstractElement> children = RMFUtils.createChildren((EList<SpecHierarchy>)specHierarchy.getChildren(), mapping, scope);
            Section createdObject = null;
            SpecObject specObject = specHierarchy.getObject();
            if (specObject != null) {
                SpecType specType = ReqIF10Util.getSpecType((SpecElementWithAttributes)specObject);
                String identifier = specType.getIdentifier();
                MappingElement elementMapping = DataUtil.getElementMapping(mapping, (String)identifier, (String)specType.getLongName());
                if (elementMapping != null) {
                    String id = RMFUtils.getID(elementMapping, (SpecElementWithAttributes)specObject);
                    String name = RMFUtils.getName(elementMapping, (SpecElementWithAttributes)specObject);
                    createdObject = RMFUtils.createElement(mapping, (SpecElementWithAttributes)specObject, identifier, specType.getLongName(), id, name);
                    if (scope != null && createdObject instanceof Requirement) {
                        createdObject.getScopes().add((Object)scope);
                    }
                }
            } else {
                createdObject = dataManager.createSection(specHierarchy.getLongName(), specHierarchy.getDesc(), specHierarchy.getIdentifier());
            }
            if (createdObject != null) {
                if (children != null && !children.isEmpty()) {
                    if (createdObject instanceof Section) {
                        dataManager.addElementsToSection(createdObject, children.toArray(new AbstractElement[children.size()]));
                    } else {
                        logger.error("The element " + createdObject.getId() + " is not a Section Type, his children will be missed");
                    }
                }
                result.add((AbstractElement)createdObject);
                continue;
            }
            if (children == null || children.isEmpty()) continue;
            logger.error("The element " + specHierarchy.getIdentifier() + " can't be created, his children will be missed");
        }
        return result;
    }

    private static String getName(MappingElement elementMapping, SpecElementWithAttributes element) {
        EList attributes = elementMapping.getAttributes();
        for (MappingAttribute attribute : attributes) {
            if (!"text".equalsIgnoreCase(attribute.getTargetAttribute().getName())) continue;
            String sourceId = attribute.getSourceId();
            for (AttributeValue value : element.getValues()) {
                AttributeDefinition attributeDefinition = ReqIF10Util.getAttributeDefinition((AttributeValue)value);
                if (sourceId != null && sourceId.equals(attributeDefinition.getIdentifier())) {
                    return ReqIF10Util.getTheValue((AttributeValue)value) == null ? null : ReqIF10Util.getTheValue((AttributeValue)value).toString();
                }
                if (attribute.getDescription() == null || !attribute.getDescription().equals(attributeDefinition.getLongName())) continue;
                return ReqIF10Util.getTheValue((AttributeValue)value).toString();
            }
        }
        return "";
    }

    private static String getID(MappingElement elementMapping, SpecElementWithAttributes element) {
        EList attributes = elementMapping.getAttributes();
        for (MappingAttribute attribute : attributes) {
            if (!"id".equalsIgnoreCase(attribute.getTargetAttribute().getName())) continue;
            String sourceId = attribute.getSourceId();
            for (AttributeValue value : element.getValues()) {
                AttributeDefinition attributeDefinition = ReqIF10Util.getAttributeDefinition((AttributeValue)value);
                if (sourceId != null && sourceId.equals(attributeDefinition.getIdentifier())) {
                    return ReqIF10Util.getTheValue((AttributeValue)value).toString();
                }
                if (attribute.getDescription() == null || !attribute.getDescription().equals(attributeDefinition.getLongName())) continue;
                return ReqIF10Util.getTheValue((AttributeValue)value).toString();
            }
        }
        return "";
    }

    protected static AbstractElement createElement(Collection<MappingElement> mapping, SpecElementWithAttributes specElement, String sourceQualifier, String longName, String id, String name) {
        MappingElement elementMapping = DataUtil.getElementMapping(mapping, (String)sourceQualifier, (String)longName);
        Requirement createdObject = null;
        if (elementMapping != null) {
            try {
                RequirementTypeImpl type = new RequirementTypeImpl(elementMapping.getTargetElement(), null);
                createdObject = type.createInstance();
                createdObject.setId(id);
                createdObject.setText(name);
                createdObject.setUri(id);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log((IStatus)new Status(4, "org.polarsys.reqcycle.repository.connector.rmf", e.getMessage()));
            }
            RMFUtils.addAttributes(elementMapping, (Collection<AttributeValue>)specElement.getValues(), (AbstractElement)createdObject);
        }
        return createdObject;
    }

    protected static void addAttributes(MappingElement elementMapping, Collection<AttributeValue> values, AbstractElement element) {
        for (AttributeValue attributeValue : values) {
            EAttribute attributeToSet;
            AttributeDefinition attributeDefinition = ReqIF10Util.getAttributeDefinition((AttributeValue)attributeValue);
            MappingAttribute attributeMapping = DataUtil.getAttributeMapping((MappingElement)elementMapping, (String)attributeDefinition.getIdentifier(), (String)attributeDefinition.getLongName());
            if (attributeMapping == null || "id".equalsIgnoreCase((attributeToSet = attributeMapping.getTargetAttribute()).getName()) || "text".equalsIgnoreCase(attributeToSet.getName())) continue;
            try {
                if (attributeValue instanceof AttributeValueEnumeration) {
                    for (EnumValue enumValue : ((AttributeValueEnumeration)attributeValue).getValues()) {
                        String name = enumValue.getLongName();
                        EAttribute targetAttribute = attributeToSet;
                        if (!(targetAttribute.getEAttributeType() instanceof EEnum)) continue;
                        EEnumLiteral enumLiteral = ((EEnum)targetAttribute.getEAttributeType()).getEEnumLiteral(name);
                        element.eSet((EStructuralFeature)attributeToSet, (Object)enumLiteral);
                    }
                }
                Object theValue = ReqIF10Util.getTheValue((AttributeValue)attributeValue);
                if (attributeToSet.getEType().isInstance(theValue)) {
                    element.eSet((EStructuralFeature)attributeToSet, theValue);
                    continue;
                }
                logger.error("Can't add the attribute " + attributeDefinition.getIdentifier() + " to the element " + element.getText());
            }
            catch (Exception exception) {
                logger.error("Can't add the attribute " + attributeDefinition.getIdentifier() + " to the element " + element.getText());
            }
        }
    }
}

