/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ui.components.dialogs;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.reqcycle.ui.components.dialogs.AbstractCustomDialog;

public class ComboInputDialog
extends AbstractCustomDialog {
    private final boolean readOnly;
    private ComboViewer comboViewer;
    private Object selectedItem;
    private IContentProvider comboContentProvider;
    private ILabelProvider comboILabelProvider;

    public ComboInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, Object initialInput, IInputValidator validator) {
        this(parentShell, dialogTitle, dialogMessage, initialInput, validator, true);
    }

    public ComboInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, Object initialInput, IInputValidator validator, boolean readOnly) {
        super(parentShell, dialogTitle, dialogMessage, initialInput, validator);
        this.readOnly = readOnly;
    }

    @Override
    protected void createCustomDialogArea(Composite parent) {
        this.comboViewer = this.readOnly ? new ComboViewer(parent, 8) : new ComboViewer(parent);
        Combo combo = this.comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(768));
        if (!this.readOnly) {
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ComboInputDialog.this.validateInput();
                }
            });
        }
        if (this.comboContentProvider == null) {
            this.comboContentProvider = ArrayContentProvider.getInstance();
        }
        if (this.comboILabelProvider == null) {
            this.comboILabelProvider = new LabelProvider();
        }
        this.comboViewer.setContentProvider(this.comboContentProvider);
        this.comboViewer.setLabelProvider((IBaseLabelProvider)this.comboILabelProvider);
        this.comboViewer.setInput(this.getInput());
        combo.addListener(13, (Listener)this);
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.getValidator() != null) {
            errorMessage = this.getValidator().isValid(this.comboViewer.getCombo().getText());
        }
        this.setErrorMessage(errorMessage);
    }

    protected void buttonPressed(int buttonId) {
        this.selectedItem = buttonId == 0 ? ((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement() : null;
        super.buttonPressed(buttonId);
    }

    public Object getSelectedItem() {
        Iterator<Object> iter = this.getSelectedItems().iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    @Override
    public Collection<Object> getSelectedItems() {
        return Arrays.asList(this.selectedItem);
    }

    public void setComboContentProvider(IContentProvider contentProvider) {
        this.comboContentProvider = contentProvider;
    }

    public void setComboLabelProvider(ILabelProvider labelProvider) {
        this.comboILabelProvider = labelProvider;
    }

    protected ComboViewer getComboViewer() {
        return this.comboViewer;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0 && btn != null) {
            btn.setEnabled(false);
        }
        return btn;
    }

    @Override
    public void handleEvent(Event event) {
        if (this.comboViewer == null) {
            return;
        }
        this.enableOkButton(this.comboViewer.getSelection() != null);
    }
}

