/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.uri.visitors;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.eclipse.core.runtime.IAdaptable;
import org.polarsys.reqcycle.uri.visitors.IVisitor;

public class CompositeVisitor
implements IVisitor {
    protected Queue<IVisitor> visitors = null;
    Map<IVisitor, Boolean> status = new HashMap<IVisitor, Boolean>();

    public CompositeVisitor(IVisitor ... visitors) {
        this(Arrays.asList(visitors));
    }

    public CompositeVisitor(Collection<IVisitor> visitors) {
        this.visitors = new ArrayDeque<IVisitor>(visitors);
    }

    @Override
    public boolean visit(Object o, IAdaptable adaptable) {
        boolean result = false;
        for (IVisitor v : this.visitors) {
            Boolean statusBool = this.status.get(v);
            if (statusBool != null && !statusBool.booleanValue()) continue;
            boolean tmp = v.visit(o, adaptable);
            this.status.put(v, tmp);
            result |= tmp;
        }
        return result;
    }

    @Override
    public void start(IAdaptable adaptable) {
        this.status.clear();
        for (IVisitor v : this.visitors) {
            this.status.put(v, true);
            v.start(adaptable);
        }
    }

    @Override
    public void end(IAdaptable adaptable) {
        for (IVisitor v : this.visitors) {
            v.end(adaptable);
        }
    }
}

