/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.ocl.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.EvaluationVisitorImpl;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.utilities.Visitor;
import org.polarsys.reqcycle.utils.ocl.OCLEvaluator;
import org.polarsys.reqcycle.utils.ocl.extensions.JavaImplementedOCLOperation;
import org.polarsys.reqcycle.utils.ocl.internal.CustomEnvironmentFactory;
import org.polarsys.reqcycle.utils.ocl.internal.CustomEvaluationEnvironment;
import org.polarsys.reqcycle.utils.ocl.utils.OCLEvaluationUtil;

public class OCLEvaluatorImpl
implements OCLEvaluator {
    private static final String STORAGE_SOURCE = "org.polarsys.reqcycle.utils.ocl.storage";
    private OCL ocl;
    private Map<EOperationKey, EOperation> compiledOperations = new HashMap<EOperationKey, EOperation>();
    private boolean dirty = false;

    public OCLEvaluatorImpl() {
        this(new CustomEnvironmentFactory());
    }

    public OCLEvaluatorImpl(EcoreEnvironmentFactory factory) {
        this.ocl = OCL.newInstance((EnvironmentFactory)factory);
        ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.implicitRootClass((Environment)this.ocl.getEnvironment()), (Object)EcorePackage.Literals.EOBJECT);
        ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ProblemOption.CLOSURE_ITERATOR, (Object)ProblemHandler.Severity.OK);
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)true);
    }

    @Override
    public OCL getOCL() {
        return this.ocl;
    }

    @Override
    public EOperation getCompiledOperation(String operationName, Object context) {
        if (context instanceof EObject) {
            for (EOperationKey key : this.compiledOperations.keySet()) {
                EClassifier keyClassifier;
                if (key.name == null || !key.name.equals(operationName) || !(keyClassifier = key.classifier).isInstance(context)) continue;
                return this.compiledOperations.get(key);
            }
        }
        return null;
    }

    @Override
    public void setOclExtentMap(Map<EClass, ? extends Set<? extends EObject>> extentMap) {
        this.ocl.setExtentMap(extentMap);
    }

    @Override
    public Map<EClass, ? extends Set<? extends EObject>> getOclExtentMap() {
        return this.ocl.getExtentMap();
    }

    @Override
    public EClassifier lookupEClassifier(String metamodelPrefix, String eClassifierContext) {
        OCL.Helper oclHelper = this.getOCL().createOCLHelper();
        List<String> lookupParameters = Arrays.asList(metamodelPrefix, eClassifierContext);
        EClassifier eClassifier = (EClassifier)oclHelper.getOCL().getEnvironment().lookupClassifier(lookupParameters);
        return eClassifier;
    }

    @Override
    public EClassifier lookupEClassifier(List<String> parameters) {
        OCL.Helper oclHelper = this.getOCL().createOCLHelper();
        EClassifier eClassifier = (EClassifier)oclHelper.getOCL().getEnvironment().lookupClassifier(parameters);
        return eClassifier;
    }

    @Override
    public Object evaluateQuery(String queryBody, Object context) throws ParserException {
        return this.evaluateQuery(queryBody, context, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object evaluateQuery(String queryBody, Object context, Map<String, ? extends Object> globalVars) throws ParserException {
        block8: {
            if (globalVars != null) {
                for (Map.Entry<String, ? extends Object> entry : globalVars.entrySet()) {
                    var = ExpressionsFactory.eINSTANCE.createVariable();
                    var.setName(entry.getKey());
                    var.setType((Object)OCLEvaluationUtil.getClassifier(entry.getValue()));
                    this.getOCL().getEnvironment().addElement(var.getName(), var, true);
                }
            }
            oclHelper = this.getOCL().createOCLHelper();
            oclHelper.setContext((Object)OCLEvaluationUtil.getClassifier(context));
            evalResult = null;
            try {
                oclExpression = oclHelper.createQuery(queryBody);
                if (globalVars != null) {
                    for (Map.Entry<String, ? extends Object> entry : globalVars.entrySet()) {
                        this.getOCL().getEvaluationEnvironment().add(entry.getKey(), entry.getValue());
                    }
                }
                evalResult = this.getOCL().evaluate(context, (OCLExpression)oclExpression);
            }
            finally {
                this.getOCL().getEnvironment().getVariables().clear();
                if (globalVars == null) break block8;
                ** for (entry : globalVars.entrySet())
            }
lbl-1000:
            // 1 sources

            {
                this.getOCL().getEvaluationEnvironment().remove(entry.getKey());
                continue;
            }
        }
        return evalResult;
    }

    @Override
    public EOperation compileOperation(JavaImplementedOCLOperation operation) {
        String name = operation.getName();
        if (operation != null && name != null && !name.isEmpty() && this.getOCL().getEvaluationEnvironment() instanceof CustomEvaluationEnvironment) {
            CustomEvaluationEnvironment evaluationEnvironment = (CustomEvaluationEnvironment)this.getOCL().getEvaluationEnvironment();
            evaluationEnvironment.addCustomJavaOperation(operation);
            EClassifier eClassifier = operation.getEClassifier();
            List<Variable<EClassifier, EParameter>> parameters = operation.getParameters();
            return (EOperation)this.getOCL().getEnvironment().defineOperation((Object)eClassifier, name, (Object)operation.getType(), parameters, (Object)EcoreFactory.eINSTANCE.createConstraint());
        }
        return null;
    }

    @Override
    public EOperation compileOperation(String operationDef, EClassifier eClassifier) throws ParserException {
        EOperation eOperation;
        OCL.Helper oclHelper = this.getOCL().createOCLHelper();
        oclHelper.setContext((Object)eClassifier);
        try {
            eOperation = (EOperation)oclHelper.defineOperation(operationDef);
        }
        catch (ParserException e) {
            this.dirty = true;
            throw e;
        }
        oclHelper.setOperationContext((Object)eClassifier, (Object)eOperation);
        this.setContextOperation(eClassifier, eOperation);
        this.compiledOperations.put(new EOperationKey(eOperation.getName(), eClassifier), eOperation);
        return eOperation;
    }

    @Override
    public EOperation compileOperation(String operationDef, String metaModelPrefix, String eClassifierContext) throws ParserException {
        OCL.Helper oclHelper = this.getOCL().createOCLHelper();
        List<String> lookupParameters = Arrays.asList(metaModelPrefix, eClassifierContext);
        EClassifier eClassifier = (EClassifier)oclHelper.getOCL().getEnvironment().lookupClassifier(lookupParameters);
        return this.compileOperation(operationDef, eClassifier);
    }

    protected void setContextOperation(EClassifier eclass, EOperation op) {
        EAnnotation annot = op.getEAnnotation(STORAGE_SOURCE);
        if (annot == null) {
            annot = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
            annot.setSource(STORAGE_SOURCE);
            op.getEAnnotations().add((Object)annot);
        }
        annot.getReferences().clear();
        annot.getReferences().add((Object)eclass);
    }

    protected EClassifier getContextOperation(EOperation op) {
        EAnnotation annot = op.getEAnnotation(STORAGE_SOURCE);
        return (EClassifier)annot.getReferences().get(0);
    }

    @Override
    public Object evaluateOperation(EOperation eOperation, EObject context, Object[] args) {
        EvaluationEnvironment evaluationEnvironment = this.getOCL().getEvaluationEnvironment();
        evaluationEnvironment.clear();
        evaluationEnvironment.add("self", (Object)context);
        int i = 0;
        while (i < args.length) {
            EParameter p = (EParameter)eOperation.getEParameters().get(i);
            evaluationEnvironment.add(p.getName(), args[i]);
            ++i;
        }
        Map extentMap = this.getOCL().getExtentMap();
        if (extentMap == null) {
            extentMap = evaluationEnvironment.createExtentMap((Object)context);
        }
        EvaluationVisitorImpl visitor = new EvaluationVisitorImpl(this.getOCL().getEnvironment(), evaluationEnvironment, extentMap);
        OperationCallExp<EClassifier, Object> expression = OCLEvaluatorImpl.getExpression(eOperation);
        Object result = null;
        if (this.getContextOperation(eOperation).isInstance((Object)context)) {
            result = expression.accept((Visitor)visitor);
        }
        evaluationEnvironment.clear();
        return result;
    }

    protected static VariableExp<EClassifier, EParameter> getVariable(String name, EClassifier type) {
        Variable self = ExpressionsFactory.eINSTANCE.createVariable();
        self.setName(name);
        self.setType((Object)type);
        VariableExp var = ExpressionsFactory.eINSTANCE.createVariableExp();
        var.setName(name);
        var.setReferredVariable(self);
        return var;
    }

    protected static OperationCallExp<EClassifier, Object> getExpression(EOperation eOperation) {
        OperationCallExp result = ExpressionsFactory.eINSTANCE.createOperationCallExp();
        result.setReferredOperation((Object)eOperation);
        VariableExp<EClassifier, EParameter> var = OCLEvaluatorImpl.getVariable("self", (EClassifier)eOperation.getEContainingClass());
        var.setType((Object)eOperation.getEContainingClass());
        for (EParameter arg : eOperation.getEParameters()) {
            VariableExp<EClassifier, EParameter> v = OCLEvaluatorImpl.getVariable(arg.getName(), arg.getEType());
            result.getArgument().add(v);
        }
        result.setSource(var);
        result.setType((Object)eOperation.getEType());
        return result;
    }

    protected OCL createOCL(List<String> listPackages) {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory(EPackage.Registry.INSTANCE);
        Environment pckContext = factory.createPackageContext(this.ocl.getEnvironment(), listPackages);
        OCL newOcl = OCL.newInstance((Environment)pckContext);
        return newOcl;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    private class EOperationKey {
        protected String name;
        protected EClassifier classifier;

        public EOperationKey(String name, EClassifier classifier) {
            this.name = name;
            this.classifier = classifier;
        }

        public boolean equals(Object obj) {
            if (obj instanceof EOperationKey) {
                return this.name != null && this.name.equals(((EOperationKey)obj).name) && this.classifier != null && this.classifier.equals(((EOperationKey)obj).classifier);
            }
            return false;
        }

        public int hashCode() {
            if (this.name != null) {
                return this.name.hashCode();
            }
            return super.hashCode();
        }
    }
}

