/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.CustomType;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Type;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeConfigContainer;

public class ConfigUtils {
    public static Type getType(Configuration conf, String id) {
        TypeConfigContainer container = conf.getParent();
        return ConfigUtils.getType(container, id);
    }

    public static Iterable<CustomType> getCustomTypeSubTypeOf(Configuration conf, String id) {
        TypeConfigContainer container = conf.getParent();
        return ConfigUtils.getCustomTypeSubTypeOf(container, id);
    }

    public static Iterable<CustomType> getCustomTypeSubTypeOf(TypeConfigContainer container, final String id) {
        return Iterables.filter((Iterable)Iterables.filter(container.getTypes(), (Predicate)new Predicate<Type>(){

            public boolean apply(Type t) {
                if (t instanceof CustomType) {
                    CustomType custom = (CustomType)t;
                    return id.equals(custom.getSuperType().getTypeId());
                }
                return false;
            }
        }), CustomType.class);
    }

    public static Type getType(TypeConfigContainer container, final String id) {
        return (Type)Iterables.find(container.getTypes(), (Predicate)new Predicate<Type>(){

            public boolean apply(Type t) {
                return id.equals(t.getTypeId());
            }
        }, null);
    }

    public static Iterable<CustomType> getCustomTypesUsedInRelations(Configuration config, final String typeId) {
        return Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform(config.getRelations(), (Function)new Function<Relation, Iterable<CustomType>>(){

            public Iterable<CustomType> apply(Relation r) {
                CustomType upstreamType;
                CustomType downstreamType;
                LinkedList<CustomType> result = new LinkedList<CustomType>();
                if (r.getDownstreamType() instanceof CustomType && (downstreamType = (CustomType)r.getDownstreamType()).getSuperType().getTypeId().equals(typeId)) {
                    result.add(downstreamType);
                }
                if (r.getUpstreamType() instanceof CustomType && (upstreamType = (CustomType)r.getUpstreamType()).getSuperType().getTypeId().equals(typeId)) {
                    result.add(upstreamType);
                }
                return result;
            }
        })));
    }
}

