/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.builder;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.polarsys.reqcycle.traceability.builder.IBuildingDecoration;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.traceability.storage.NoProjectStorageException;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.RelationBasedType;
import org.polarsys.reqcycle.traceability.types.RelationUtils;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IObjectHandler;
import org.polarsys.reqcycle.uri.model.Reachable;

public class AttributesConfigurationBuildingDecoration
extends IBuildingDecoration.IBuildingDecorationAdapter {
    @Inject
    protected ITypesConfigurationProvider provider;
    @Inject
    protected IReachableManager manager;
    @Inject
    protected IStorageProvider storageProvider;
    protected ITraceabilityStorage currentStorage;
    protected Set<Reachable> allTraceabilityWithProperties = new HashSet<Reachable>();
    private Configuration defaultConfiguration = null;

    public void startBuild(ITraceabilityBuilder.IBuilderCallBack callBack, Reachable reachable) {
        this.defaultConfiguration = this.provider.getDefaultConfiguration();
        if (this.defaultConfiguration == null) {
            return;
        }
        try {
            this.currentStorage = this.storageProvider.getProjectStorageFromLinkId(reachable);
        }
        catch (NoProjectStorageException e) {
            e.printStackTrace();
        }
    }

    public void endBuild(ITraceabilityBuilder.IBuilderCallBack callBack, Reachable reachable) {
        if (this.currentStorage != null) {
            this.currentStorage.save();
            this.currentStorage = null;
        }
        this.defaultConfiguration = null;
    }

    public boolean newUpwardRelation(ITraceabilityBuilder.IBuilderCallBack callBack, Object traceability, Object resource, Object source, List<? extends Object> targets, TType kind) {
        if (kind instanceof RelationBasedType) {
            return true;
        }
        if (this.defaultConfiguration == null) {
            return true;
        }
        Reachable reachableSource = this.getReachable(source);
        Reachable reachableTrac = this.getReachable(traceability);
        boolean newOne = true;
        for (Object object : targets) {
            Reachable reachableTarget = this.getReachable(object);
            Iterable<Relation> relations = RelationUtils.getAgregatingRelations(kind, this.defaultConfiguration, reachableSource, reachableTarget, ITraceabilityEngine.DIRECTION.UPWARD);
            for (Relation r : relations) {
                newOne = false;
                RelationBasedType relBasedType = new RelationBasedType(r, kind);
                callBack.newUpwardRelation(traceability, resource, source, targets, (TType)relBasedType);
                if (this.currentStorage == null) continue;
                this.currentStorage.addUpdateProperty(reachableTrac, "relationKind", r.getKind());
            }
        }
        return newOne;
    }

    private Reachable getReachable(Object object) {
        try {
            IObjectHandler handler = this.manager.getHandlerFromObject(object);
            return handler.getFromObject(object).getReachable();
        }
        catch (IReachableHandlerException iReachableHandlerException) {
            System.out.println("could not get reachable for " + object);
            return null;
        }
    }
}

