/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.types.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.types.internal.ETypeImpl;

public class AttributeImpl
implements IAttribute,
IAdaptable {
    protected EStructuralFeature feature;
    protected IType type;
    protected boolean isMany = false;

    public AttributeImpl(String name, IType type, boolean isMany) {
        this.type = type;
        this.isMany = isMany;
        EClassifier eType = null;
        if (type instanceof IAdaptable) {
            eType = (EClassifier)((IAdaptable)type).getAdapter(EClassifier.class);
        }
        this.feature = AttributeImpl.createFeature(name, eType, isMany);
    }

    public AttributeImpl(String name, EClassifier eType, boolean isMany) {
        this.isMany = isMany;
        this.feature = AttributeImpl.createFeature(name, eType, isMany);
        this.type = ETypeImpl.createEType(eType);
    }

    protected static EStructuralFeature createFeature(String name, EClassifier eType, boolean isMany) {
        EAttribute feature = null;
        if (eType instanceof EDataType) {
            feature = EcoreFactory.eINSTANCE.createEAttribute();
        } else if (eType instanceof EClass) {
            feature = EcoreFactory.eINSTANCE.createEReference();
        } else {
            throw new RuntimeException();
        }
        feature.setEType(eType);
        feature.setName(name);
        if (isMany) {
            feature.setUpperBound(-1);
        }
        return feature;
    }

    protected AttributeImpl(EStructuralFeature feature) {
        this.feature = feature;
        this.type = ETypeImpl.createEType(feature.getEType());
    }

    @Override
    public String getName() {
        return this.feature != null ? this.feature.getName() : null;
    }

    @Override
    public boolean isHidden() {
        return this.feature.getEAnnotation("hidden") != null;
    }

    public Object getAdapter(Class adapter) {
        if (EStructuralFeature.class.isAssignableFrom(adapter)) {
            return this.feature;
        }
        return null;
    }

    @Override
    public IType getType() {
        return this.type;
    }
}

