/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.update.pages;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.reqcycle.repository.connector.ConnectorDescriptor;
import org.polarsys.reqcycle.repository.connector.IConnector;
import org.polarsys.reqcycle.repository.connector.IConnectorManager;
import org.polarsys.reqcycle.repository.connector.IURIValidatorConnector;
import org.polarsys.reqcycle.repository.connector.update.MutexRule;
import org.polarsys.reqcycle.repository.connector.update.UpdateRequirementSourcesHandler;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class DialogUpdatePage
extends TitleAreaDialog {
    private List<RequirementSource> reqSources;
    private Map<RequirementSource, String> mapSourcesToModify;
    IConnectorManager connManager = (IConnectorManager)ZigguratInject.make(IConnectorManager.class);
    private Map<Button, Boolean> mapStatus;

    public DialogUpdatePage(Shell parent) {
        super(parent);
        this.setShellStyle(1264);
        this.reqSources = new ArrayList<RequirementSource>();
        this.mapSourcesToModify = new HashMap<RequirementSource, String>();
        this.mapStatus = new HashMap<Button, Boolean>();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Requirement updating");
    }

    public void create() {
        super.create();
        this.setTitle("Requirements sources updating");
        this.setMessage("Change requirements sources paths and click OK for updating ");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        Composite top = new Composite(composite, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        top.setLayoutData((Object)new GridData(1808));
        ScrolledComposite scrolledComposite = new ScrolledComposite(top, 2816);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite composite_1 = new Composite((Composite)scrolledComposite, 0);
        composite_1.setLayout((Layout)new GridLayout(1, false));
        ImmutableListMultimap allSourcesByConnector = Multimaps.index((Iterable)Iterables.filter(this.reqSources, (Predicate)new Predicate<RequirementSource>(){

            public boolean apply(RequirementSource arg0) {
                return arg0.getRepositoryURI() != null && arg0.getRepositoryURI().trim().length() > 0;
            }
        }), (Function)new Function<RequirementSource, String>(){

            public String apply(RequirementSource arg0) {
                return DialogUpdatePage.this.connManager.get(arg0.getConnectorId()).getName();
            }
        });
        for (String connectorId : allSourcesByConnector.keySet()) {
            Group group = new Group(composite_1, 0);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setText(connectorId);
            group.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
            for (RequirementSource rs : allSourcesByConnector.get((Object)connectorId)) {
                this.createGroupWidgets(group, rs);
            }
        }
        scrolledComposite.setContent((Control)composite_1);
        scrolledComposite.setMinSize(composite_1.computeSize(-1, -1));
        return composite;
    }

    private void createGroupWidgets(Group group, RequirementSource rs) {
        this.builControlLine(group, rs);
    }

    private Group builControlLine(Group groupWidgets, final RequirementSource reqSource) {
        Label lblResourceName = new Label((Composite)groupWidgets, 0);
        lblResourceName.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        lblResourceName.setText(String.valueOf(reqSource.getName()) + " : ");
        final Text txtResourcePath = new Text((Composite)groupWidgets, 2048);
        txtResourcePath.setEnabled(false);
        GridData layoutData = new GridData(4, 128, true, false, 1, 1);
        layoutData.horizontalIndent = 3;
        txtResourcePath.setLayoutData((Object)layoutData);
        txtResourcePath.setText(reqSource.getRepositoryURI());
        this.mapSourcesToModify.put(reqSource, txtResourcePath.getText());
        txtResourcePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialogUpdatePage.this.mapSourcesToModify.put(reqSource, txtResourcePath.getText());
            }
        });
        final ControlDecoration controlDec = new ControlDecoration((Control)txtResourcePath, 16512);
        final Button Browse = new Button((Composite)groupWidgets, 0);
        Browse.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Browse.setText("...");
        Browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List uris;
                ResourceDialog dialog = new ResourceDialog(DialogUpdatePage.this.getShell(), "Select a document", 0);
                if (dialog.open() == 0 && !(uris = dialog.getURIs()).isEmpty()) {
                    URI uri = (URI)uris.get(0);
                    txtResourcePath.setText(uri.toString());
                    Display display = DialogUpdatePage.this.getShell().getDisplay();
                    FontData fontData = display.getSystemFont().getFontData()[0];
                    txtResourcePath.setFont(new Font((Device)display, fontData.getName(), fontData.getHeight(), 1));
                    String idconnect = reqSource.getConnectorId();
                    ConnectorDescriptor connectorD = DialogUpdatePage.this.connManager.get(idconnect);
                    try {
                        IConnector createConnector = connectorD.createConnector();
                        if (createConnector instanceof IURIValidatorConnector) {
                            IURIValidatorConnector validator = (IURIValidatorConnector)createConnector;
                            IStatus status = validator.validate(uri);
                            DialogUpdatePage.this.mapStatus.put(Browse, true);
                            controlDec.hide();
                            if (!status.isOK()) {
                                DialogUpdatePage.this.setMessage("Some requirements sources paths are not supported. Retry and press OK to update");
                                DialogUpdatePage.this.mapStatus.put(Browse, false);
                                controlDec.show();
                                controlDec.setDescriptionText(status.getMessage());
                                if (status.getSeverity() == 4) {
                                    FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                                    controlDec.setImage(fieldDecoration.getImage());
                                } else {
                                    FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                                    controlDec.setImage(fieldDecoration.getImage());
                                }
                            }
                        }
                        createConnector.dispose();
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                    }
                    if (DialogUpdatePage.this.mapStatus != null && DialogUpdatePage.this.mapStatus.containsValue(false)) {
                        DialogUpdatePage.this.getButton(0).setEnabled(false);
                    } else {
                        DialogUpdatePage.this.getButton(0).setEnabled(true);
                        DialogUpdatePage.this.setMessage("All requirements sources paths are supported. Press OK to update");
                    }
                }
            }
        });
        return groupWidgets;
    }

    protected void okPressed() {
        super.okPressed();
        Job job = new Job("requirements sources updating"){

            protected IStatus run(IProgressMonitor monitor) {
                UpdateRequirementSourcesHandler updateRequirementSources = new UpdateRequirementSourcesHandler(DialogUpdatePage.this.mapSourcesToModify);
                updateRequirementSources.run(monitor);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)MutexRule.INSTANCE);
        job.setUser(false);
        job.schedule();
    }

    public List<RequirementSource> getReqSources() {
        return this.reqSources;
    }

    public void setReqSources(List<RequirementSource> reqSources) {
        this.reqSources = reqSources;
    }
}

