/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.prefs.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.polarsys.reqcycle.utils.configuration.Activator;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ReqcyclePrefsImportWizard
extends Wizard
implements IImportWizard {
    protected IConfigurationManager confManager = (IConfigurationManager)ZigguratInject.make(IConfigurationManager.class);
    protected IPath inputPath;
    protected boolean includeReqSources = false;

    public void addPages() {
        this.addPage((IWizardPage)new WizardPage("Import ReqCycle preferences"){

            public void createControl(Composite parent) {
                this.setPageComplete(false);
                Composite mainComposite = new Composite(parent, 0);
                mainComposite.setLayout((Layout)new FillLayout(256));
                Composite topComposite = new Composite(mainComposite, 0);
                topComposite.setLayout((Layout)new GridLayout(1, false));
                Group topGroup = new Group(topComposite, 0);
                topGroup.setLayout((Layout)new GridLayout(3, false));
                topGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                topGroup.setText("Import Information");
                Label lblDestination = new Label((Composite)topGroup, 0);
                lblDestination.setText("Zip Conf File :");
                final Text textInput = new Text((Composite)topGroup, 2048);
                textInput.setEnabled(false);
                textInput.setEditable(false);
                textInput.setTouchEnabled(true);
                textInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                if (ReqcyclePrefsImportWizard.this.inputPath != null) {
                    textInput.setText(ReqcyclePrefsImportWizard.this.inputPath.toString());
                    this.setPageComplete(true);
                }
                Button btnBrowse = new Button((Composite)topGroup, 0);
                btnBrowse.setText("Browse");
                btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ResourceSelectionDialog d = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "zip selection");
                        int open = d.open();
                        if (open == 0 && d.getResult() != null && d.getResult().length > 0) {
                            (this).ReqcyclePrefsImportWizard.this.inputPath = ((IFile)d.getResult()[0]).getFullPath();
                            textInput.setText((this).ReqcyclePrefsImportWizard.this.inputPath.toString());
                            this.setPageComplete(true);
                        }
                    }
                });
                final Button reqSourcesButton = new Button((Composite)topGroup, 32);
                reqSourcesButton.setText("Import requirement sources");
                reqSourcesButton.setSelection(ReqcyclePrefsImportWizard.this.includeReqSources);
                reqSourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).ReqcyclePrefsImportWizard.this.includeReqSources = reqSourcesButton.getSelection();
                    }
                });
                this.setControl((Control)mainComposite);
            }
        });
    }

    public boolean performFinish() {
        IPath prefsFolderPath = Activator.getDefault().getStateLocation();
        File prefsFolder = new File(prefsFolderPath.toOSString());
        IFile inputFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.inputPath);
        if (inputFile != null) {
            this.confManager.unload();
            File[] fileArray = prefsFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
            try {
                ZipInputStream zipStream = new ZipInputStream(inputFile.getContents());
                ZipEntry next = zipStream.getNextEntry();
                while (next != null) {
                    if (this.includeReqSources || !next.getName().startsWith("org.polarsys.reqcycle.repositories")) {
                        File f = new File(prefsFolder, next.getName());
                        FileOutputStream os = new FileOutputStream(f);
                        IOUtils.copy((InputStream)zipStream, (OutputStream)os);
                        os.close();
                    }
                    next = zipStream.getNextEntry();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean res = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Restart needed", (String)"A restart of Eclipse is needed to validate the imported ReqCycle configuration. Do you want to restart now ?");
            if (res) {
                PlatformUI.getWorkbench().restart();
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof IFile) {
            this.inputPath = ((IFile)selection.getFirstElement()).getFullPath();
        }
    }
}

